/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.jboss.wsf.spi.util.SecurityActions;

public abstract class ServiceLoader {
    public static Object loadService(String propertyName, String defaultFactory) {
        Object factory = ServiceLoader.loadFromServices(propertyName, null);
        if (factory == null) {
            factory = ServiceLoader.loadFromPropertiesFile(propertyName, null);
        }
        if (factory == null) {
            factory = ServiceLoader.loadFromSystemProperty(propertyName, defaultFactory);
        }
        return factory;
    }

    public static Object loadFromServices(String propertyName, String defaultFactory) {
        String filename;
        Object factory = null;
        String factoryName = null;
        ClassLoader loader = SecurityActions.getContextClassLoader();
        InputStream inStream = SecurityActions.getResourceAsStream(loader, filename = "META-INF/services/" + propertyName);
        if (inStream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                factoryName = br.readLine();
                br.close();
                if (factoryName != null) {
                    Class<?> factoryClass = SecurityActions.loadClass(loader, factoryName);
                    factory = factoryClass.newInstance();
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && defaultFactory != null) {
            factory = ServiceLoader.loadDefault(defaultFactory);
        }
        return factory;
    }

    public static Object loadFromSystemProperty(String propertyName, String defaultFactory) {
        Object factory = null;
        ClassLoader loader = SecurityActions.getContextClassLoader();
        PropertyAccessAction action = new PropertyAccessAction(propertyName);
        String factoryName = (String)AccessController.doPrivileged(action);
        if (factoryName != null) {
            try {
                Class<?> factoryClass = SecurityActions.loadClass(loader, factoryName);
                factory = factoryClass.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && defaultFactory != null) {
            factory = ServiceLoader.loadDefault(defaultFactory);
        }
        return factory;
    }

    public static Object loadFromPropertiesFile(String propertyName, String defaultFactory) {
        Object factory = null;
        String factoryName = null;
        ClassLoader loader = SecurityActions.getContextClassLoader();
        PrivilegedAction action = new PropertyAccessAction("java.home");
        String javaHome = (String)AccessController.doPrivileged(action);
        File jaxmFile = new File(javaHome + "/lib/jaxws.properties");
        if (((Boolean)AccessController.doPrivileged(new PropertyFileExistAction(jaxmFile))).booleanValue()) {
            try {
                action = new PropertyFileAccessAction(jaxmFile.getCanonicalPath());
                Properties jaxmProperties = (Properties)AccessController.doPrivileged(action);
                factoryName = jaxmProperties.getProperty(propertyName);
                if (factoryName != null) {
                    Class<?> factoryClass = SecurityActions.loadClass(loader, factoryName);
                    factory = factoryClass.newInstance();
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && defaultFactory != null) {
            factory = ServiceLoader.loadDefault(defaultFactory);
        }
        return factory;
    }

    private static Object loadDefault(String defaultFactory) {
        Object factory = null;
        ClassLoader loader = SecurityActions.getContextClassLoader();
        if (defaultFactory != null) {
            try {
                Class<?> factoryClass = SecurityActions.loadClass(loader, defaultFactory);
                factory = factoryClass.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load: " + defaultFactory, t);
            }
        }
        return factory;
    }

    private static class PropertyFileExistAction
    implements PrivilegedAction {
        private File file;

        PropertyFileExistAction(File file) {
            this.file = file;
        }

        public Object run() {
            return this.file.exists();
        }
    }

    private static class PropertyFileAccessAction
    implements PrivilegedAction {
        private String filename;

        PropertyFileAccessAction(String filename) {
            this.filename = filename;
        }

        public Object run() {
            InputStream inStream = null;
            try {
                inStream = new FileInputStream(this.filename);
                Properties props = new Properties();
                props.load(inStream);
                Properties properties = props;
                return properties;
            }
            catch (IOException ex) {
                throw new SecurityException("Cannot load properties: " + this.filename, ex);
            }
            finally {
                try {
                    inStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;

        PropertyAccessAction(String name) {
            this.name = name;
        }

        public Object run() {
            return System.getProperty(this.name);
        }
    }
}

