/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.classloading;

import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class ClassLoaderProvider {
    private static ClassLoaderProvider provider = new ClassLoaderProvider(){

        @Override
        public ClassLoader getWebServiceSubsystemClassLoader() {
            return 1.getContextClassLoader();
        }

        @Override
        public ClassLoader getServerIntegrationClassLoader() {
            return 1.getContextClassLoader();
        }
    };

    public static void setDefaultProvider(ClassLoaderProvider p) {
        provider = p;
    }

    public static ClassLoaderProvider getDefaultProvider() {
        return provider;
    }

    public abstract ClassLoader getWebServiceSubsystemClassLoader();

    public abstract ClassLoader getServerIntegrationClassLoader();

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

