/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.AbstractHandlerChainsMetaDataParser;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.spi.util.StAXUtils;

public class WebservicesFactory
extends AbstractHandlerChainsMetaDataParser {
    private URL descriptorURL;

    public WebservicesFactory(URL descriptorURL) {
        this.descriptorURL = descriptorURL;
    }

    public static WebservicesMetaData loadFromVFSRoot(UnifiedVirtualFile root) {
        WebservicesMetaData webservices = null;
        UnifiedVirtualFile wsdd = null;
        try {
            wsdd = root.findChild("META-INF/webservices.xml");
        }
        catch (IOException e) {
            // empty catch block
        }
        if (null == wsdd) {
            try {
                wsdd = root.findChild("WEB-INF/webservices.xml");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (wsdd != null) {
            return WebservicesFactory.load(wsdd.toURL());
        }
        return webservices;
    }

    public static WebservicesMetaData load(URL wsddUrl) {
        InputStream is = null;
        try {
            is = wsddUrl.openStream();
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            WebservicesMetaData webservicesMetaData = WebservicesFactory.parse(xmlr, wsddUrl);
            return webservicesMetaData;
        }
        catch (Exception e) {
            throw Messages.MESSAGES.failedToUnmarshall(e, wsddUrl);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static WebservicesMetaData parse(InputStream is) {
        return WebservicesFactory.parse(is, null);
    }

    public static WebservicesMetaData parse(InputStream is, URL descriptorURL) {
        try {
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            return WebservicesFactory.parse(xmlr, descriptorURL);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WebservicesMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        return WebservicesFactory.parse(reader, null);
    }

    private static WebservicesMetaData parse(XMLStreamReader reader, URL descriptorURL) throws XMLStreamException {
        int iterate;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        WebservicesMetaData metadata = null;
        switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                if (StAXUtils.match(reader, "http://java.sun.com/xml/ns/javaee", "webservices") || StAXUtils.match(reader, "http://java.sun.com/xml/ns/j2ee", "webservices")) {
                    String nsUri = reader.getNamespaceURI();
                    WebservicesFactory factory = new WebservicesFactory(descriptorURL);
                    metadata = factory.parseWebservices(reader, nsUri, descriptorURL);
                    break;
                }
                throw Messages.MESSAGES.unexpectedElement(descriptorURL != null ? descriptorURL.toString() : "webservices.xml", reader.getLocalName());
            }
        }
        return metadata;
    }

    private WebservicesMetaData parseWebservices(XMLStreamReader reader, String nsUri, URL descriptorURL) throws XMLStreamException {
        WebservicesMetaData metadata = new WebservicesMetaData(descriptorURL);
        block4: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "webservices")) {
                        return metadata;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "webservice-description")) {
                        metadata.addWebserviceDescription(this.parseWebserviceDescription(reader, nsUri, metadata));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "description") || StAXUtils.match(reader, nsUri, "display-name")) {
                        StAXUtils.elementAsString(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "icon")) {
                        while (reader.hasNext() && (reader.nextTag() != 2 || !StAXUtils.match(reader, nsUri, "icon"))) {
                            reader.next();
                        }
                        continue block4;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    WebserviceDescriptionMetaData parseWebserviceDescription(XMLStreamReader reader, String nsUri, WebservicesMetaData wsMetaData) throws XMLStreamException {
        WebserviceDescriptionMetaData description = new WebserviceDescriptionMetaData(wsMetaData);
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "webservice-description")) {
                        return description;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "webservice-description-name")) {
                        description.setWebserviceDescriptionName(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "wsdl-file")) {
                        description.setWsdlFile(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "jaxrpc-mapping-file")) {
                        description.setJaxrpcMappingFile(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "port-component")) {
                        description.addPortComponent(this.parsePortComponent(reader, nsUri, description));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private PortComponentMetaData parsePortComponent(XMLStreamReader reader, String nsUri, WebserviceDescriptionMetaData desc) throws XMLStreamException {
        PortComponentMetaData pc = new PortComponentMetaData(desc);
        block4: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "port-component")) {
                        return pc;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "port-component-name")) {
                        pc.setPortComponentName(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "description") || StAXUtils.match(reader, nsUri, "display-name")) {
                        StAXUtils.elementAsString(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "icon")) {
                        while (reader.hasNext() && (reader.nextTag() != 2 || !StAXUtils.match(reader, nsUri, "icon"))) {
                            reader.next();
                        }
                        continue block4;
                    }
                    if (StAXUtils.match(reader, nsUri, "wsdl-service")) {
                        pc.setWsdlService(StAXUtils.elementAsQName(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "wsdl-port")) {
                        pc.setWsdlPort(StAXUtils.elementAsQName(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "enable-mtom")) {
                        pc.setMtomEnabled(StAXUtils.elementAsBoolean(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "mtom-threshold")) {
                        pc.setMtomThreshold(StAXUtils.elementAsInt(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "addressing")) {
                        this.parseAddressing(reader, nsUri, pc);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "respect-binding")) {
                        this.parseRespectBinding(reader, nsUri, pc);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "protocol-binding")) {
                        pc.setProtocolBinding(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "service-endpoint-interface")) {
                        pc.setServiceEndpointInterface(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "service-impl-bean")) {
                        this.parseServiceImplBean(reader, nsUri, pc);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "handler-chains")) {
                        pc.setHandlerChains(this.parseHandlerChains(reader, nsUri));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "handler")) {
                        pc.addHandler(this.parseHandler(reader, nsUri));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private void parseAddressing(XMLStreamReader reader, String nsUri, PortComponentMetaData pc) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "addressing")) {
                        return;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "enabled")) {
                        pc.setAddressingEnabled(StAXUtils.elementAsBoolean(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "required")) {
                        pc.setAddressingRequired(StAXUtils.elementAsBoolean(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "responses")) {
                        pc.setAddressingResponses(StAXUtils.elementAsString(reader));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private void parseRespectBinding(XMLStreamReader reader, String nsUri, PortComponentMetaData pc) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "respect-binding")) {
                        return;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "enabled")) {
                        pc.setRespectBindingEnabled(StAXUtils.elementAsBoolean(reader));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private void parseServiceImplBean(XMLStreamReader reader, String nsUri, PortComponentMetaData pc) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "service-impl-bean")) {
                        return;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "servlet-link")) {
                        pc.setServletLink(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "ejb-link")) {
                        pc.setEjbLink(StAXUtils.elementAsString(reader));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    @Override
    protected String getDescriptorForLogs() {
        return this.descriptorURL != null ? this.descriptorURL.toString() : "webservices.xml";
    }

    public URL getDescriptorURL() {
        return this.descriptorURL;
    }
}

