/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.webservices.deployers.AbstractIntegrationProcessorJAXWS;
import org.jboss.as.webservices.deployers.WebServiceAnnotationInfo;
import org.jboss.as.webservices.deployers.WebServiceProviderAnnotationInfo;
import org.jboss.as.webservices.injection.WSEndpointHandlersMapping;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.ClassInfo;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public final class WSIntegrationProcessorJAXWS_HANDLER
extends AbstractIntegrationProcessorJAXWS {
    @Override
    protected void processAnnotation(DeploymentUnit unit, EEModuleDescription moduleDescription) throws DeploymentUnitProcessingException {
        WSEndpointHandlersMapping mapping = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.WS_ENDPOINT_HANDLERS_MAPPING_KEY);
        if (mapping == null) {
            return;
        }
        for (EEModuleClassDescription classDescription : moduleDescription.getClassDescriptions()) {
            String handlerName;
            ClassAnnotationInformation providreInfo;
            ClassInfo classInfo = null;
            ClassAnnotationInformation annotationInfo = classDescription.getAnnotationInformation(WebService.class);
            if (annotationInfo != null) {
                classInfo = (ClassInfo)((WebServiceAnnotationInfo)annotationInfo.getClassLevelAnnotations().get(0)).getTarget();
            }
            if ((providreInfo = classDescription.getAnnotationInformation(WebServiceProvider.class)) != null) {
                classInfo = (ClassInfo)((WebServiceProviderAnnotationInfo)providreInfo.getClassLevelAnnotations().get(0)).getTarget();
            }
            if (classInfo == null || mapping.getHandlers(classInfo.name().toString()) == null) continue;
            String endpointClassName = classInfo.name().toString();
            if (WSIntegrationProcessorJAXWS_HANDLER.isEjb3(classInfo)) {
                for (EJBEndpoint ejbEndpoint : ASHelper.getJaxwsEjbs(unit)) {
                    if (!endpointClassName.equals(ejbEndpoint.getClassName())) continue;
                    for (String handlerClassName : mapping.getHandlers(endpointClassName)) {
                        String ejbEndpointName = ejbEndpoint.getName();
                        handlerName = ejbEndpointName + "-" + handlerClassName;
                        ComponentDescription jaxwsHandlerDescription = WSIntegrationProcessorJAXWS_HANDLER.createComponentDescription(unit, handlerName, handlerClassName, ejbEndpointName);
                        WSIntegrationProcessorJAXWS_HANDLER.propagateNamingContext(jaxwsHandlerDescription, ejbEndpoint);
                    }
                }
                continue;
            }
            for (POJOEndpoint pojoEndpoint : ASHelper.getJaxwsPojos(unit)) {
                if (!endpointClassName.equals(pojoEndpoint.getClassName())) continue;
                for (String handlerClassName : mapping.getHandlers(endpointClassName)) {
                    String pojoEndpointName = pojoEndpoint.getName();
                    handlerName = pojoEndpointName + "-" + handlerClassName;
                    WSIntegrationProcessorJAXWS_HANDLER.createComponentDescription(unit, handlerName, handlerClassName, pojoEndpointName);
                }
            }
        }
    }

    private static void propagateNamingContext(ComponentDescription jaxwsHandlerDescription, EJBEndpoint ejbEndpoint) {
        ServiceName ejbContextServiceName = ejbEndpoint.getContextServiceName();
        DeploymentDescriptorEnvironment ejbEnv = ejbEndpoint.getDeploymentDescriptorEnvironment();
        jaxwsHandlerDescription.setContextServiceName(ejbContextServiceName);
        jaxwsHandlerDescription.setDeploymentDescriptorEnvironment(ejbEnv);
        jaxwsHandlerDescription.addDependency(ejbContextServiceName, ServiceBuilder.DependencyType.REQUIRED);
    }
}

