/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.managedbean.component.ManagedBeanComponentDescription;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.wsf.spi.metadata.JAXRSDeploymentMetadata;

public class JaxrsComponentDeployer
implements DeploymentUnitProcessor {
    private static final String SESSION_BEAN_DESCRIPTION_CLASS_NAME = "org.jboss.as.ejb3.component.session.SessionBeanComponentDescription";
    private static final String STATEFUL_SESSION_BEAN_DESCRIPTION_CLASS_NAME = "org.jboss.as.ejb3.component.stateful.StatefulComponentDescription";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        JAXRSDeploymentMetadata jaxrsDepMD = (JAXRSDeploymentMetadata)deploymentUnit.getAttachment(JaxrsAttachments.JAXRS_DEPLOYMENT_DATA);
        if (jaxrsDepMD == null) {
            return;
        }
        if (!jaxrsDepMD.isScanResources()) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        ModuleClassLoader loader = module.getClassLoader();
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            Class<?> componentClass = null;
            try {
                componentClass = loader.loadClass(component.getComponentClassName());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
            if (!GetRestful.isRootResource(componentClass)) continue;
            if (this.isInstanceOf(component, SESSION_BEAN_DESCRIPTION_CLASS_NAME)) {
                String jndiName;
                if (this.isInstanceOf(component, STATEFUL_SESSION_BEAN_DESCRIPTION_CLASS_NAME)) {
                    JaxrsLogger.JAXRS_LOGGER.debugf("Stateful session bean %s is being used as a JAX-RS endpoint, this is not recommended", component.getComponentName());
                    if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) continue;
                }
                Class<?>[] jaxrsType = GetRestful.getSubResourceClasses(componentClass);
                if (component.getViews().size() == 1) {
                    jndiName = "java:app/" + moduleDescription.getModuleName() + "/" + component.getComponentName();
                } else {
                    boolean found = false;
                    String foundType = null;
                    for (ViewDescription view : component.getViews()) {
                        for (Class<?> subResource : jaxrsType) {
                            if (!view.getViewClassName().equals(subResource.getName())) continue;
                            foundType = subResource.getName();
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                    if (!found) {
                        throw JaxrsLogger.JAXRS_LOGGER.typeNameNotAnEjbView(Arrays.asList(jaxrsType), component.getComponentName());
                    }
                    jndiName = "java:app/" + moduleDescription.getModuleName() + "/" + component.getComponentName() + "!" + foundType;
                }
                JaxrsLogger.JAXRS_LOGGER.debugf("Found JAX-RS Managed Bean: %s local jndi jaxRsTypeName: %s", component.getComponentClassName(), jndiName);
                StringBuilder buf = new StringBuilder();
                buf.append(jndiName).append(";").append(component.getComponentClassName()).append(";").append("true");
                jaxrsDepMD.getScannedJndiComponentResources().add(buf.toString());
                jaxrsDepMD.getScannedResourceClasses().remove(component.getComponentClassName());
                continue;
            }
            if (!(component instanceof ManagedBeanComponentDescription)) continue;
            String jndiName = "java:app/" + moduleDescription.getModuleName() + "/" + component.getComponentName();
            JaxrsLogger.JAXRS_LOGGER.debugf("Found JAX-RS Managed Bean: %s local jndi name: %s", component.getComponentClassName(), jndiName);
            StringBuilder buf = new StringBuilder();
            buf.append(jndiName).append(";").append(component.getComponentClassName()).append(";").append("true");
            jaxrsDepMD.getScannedJndiComponentResources().add(buf.toString());
            jaxrsDepMD.getScannedResourceClasses().remove(component.getComponentClassName());
        }
    }

    private boolean isInstanceOf(ComponentDescription component, String className) {
        for (Class<?> c = component.getClass(); c != Object.class && c != null; c = c.getSuperclass()) {
            if (!c.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static final class GetRestful {
        private GetRestful() {
        }

        public static Class<?> getRootResourceClass(Class<?> clazz) {
            return GetRestful.getClassWithAnnotation(clazz, Path.class);
        }

        public static Class<?>[] getSubResourceClasses(Class<?> clazz) {
            ArrayList classes = new ArrayList();
            Class<?> actualClass = clazz;
            while (GetRestful.isTopObject(actualClass)) {
                if (GetRestful.hasJAXRSAnnotations(actualClass)) {
                    return new Class[]{actualClass};
                }
                actualClass = actualClass.getSuperclass();
            }
            for (Class<?> intf : clazz.getInterfaces()) {
                if (!GetRestful.hasJAXRSAnnotations(intf)) continue;
                classes.add(intf);
            }
            return classes.toArray(new Class[classes.size()]);
        }

        private static boolean isTopObject(Class<?> actualClass) {
            return actualClass != null && actualClass != Object.class;
        }

        private static boolean hasJAXRSAnnotations(Class<?> c) {
            if (c.isAnnotationPresent(Path.class)) {
                return true;
            }
            for (Method method : c.isInterface() ? c.getMethods() : c.getDeclaredMethods()) {
                if (method.isAnnotationPresent(Path.class)) {
                    return true;
                }
                for (Annotation ann : method.getAnnotations()) {
                    if (!ann.annotationType().isAnnotationPresent(HttpMethod.class)) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean isRootResource(Class<?> clazz) {
            return GetRestful.getRootResourceClass(clazz) != null;
        }

        private static Class<?> getClassWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
            if (clazz.isAnnotationPresent(annotation)) {
                return clazz;
            }
            for (Class<?> intf : clazz.getInterfaces()) {
                if (!intf.isAnnotationPresent(annotation)) continue;
                return intf;
            }
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != Object.class && superClass != null) {
                return GetRestful.getClassWithAnnotation(superClass, annotation);
            }
            return null;
        }
    }
}

