/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.metadata.JAXRSDeploymentMetadata;

public final class ModelDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (JaxrsDeploymentMarker.isJaxrsDeployment(unit) && DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)unit)) {
            JAXRSDeployment dep = this.newDeployment(unit);
            unit.putAttachment(JaxrsAttachments.JAXRS_DEPLOYMENT_KEY, (Object)dep);
            dep.addAttachment(JAXRSDeploymentMetadata.class, unit.getAttachment(JaxrsAttachments.JAXRS_DEPLOYMENT_DATA));
            if (WeldDeploymentMarker.isWeldDeployment((DeploymentUnit)unit)) {
                dep.setProperty("isWeldDeployment", true);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private JAXRSDeployment newDeployment(DeploymentUnit unit) throws DeploymentUnitProcessingException {
        Object classLoader;
        JaxrsLogger.JAXRS_LOGGER.tracef("Creating new unified JAXRS deployment model for %s", unit);
        Module module = (Module)unit.getAttachment(Attachments.MODULE);
        if (module == null) {
            classLoader = (ClassLoader)unit.getAttachment(JaxrsAttachments.CLASSLOADER_KEY);
            if (classLoader == null) {
                throw new DeploymentUnitProcessingException("missing clasloader!");
            }
        } else {
            classLoader = module.getClassLoader();
        }
        JAXRSDeployment dep = new JAXRSDeployment(unit.getName(), (ClassLoader)classLoader);
        return dep;
    }

    private final class JAXRSDeployment
    extends AbstractExtensible
    implements Deployment {
        private String name;
        private ClassLoader classLoader;

        public JAXRSDeployment(String name, ClassLoader classLoader) {
            this.name = name;
            this.classLoader = classLoader;
        }

        public String getSimpleName() {
            return this.name;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Service getService() {
            return null;
        }
    }
}

