/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.jboss.as.jaxrs.JaxrsAnnotations;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.wsf.spi.deployment.WSFServlet;
import org.jboss.wsf.spi.metadata.JAXRSDeploymentMetadata;

public class JaxrsScanningProcessor
implements DeploymentUnitProcessor {
    private static final DotName DECORATOR = DotName.createSimple((String)"javax.decorator.Decorator");
    public static final DotName APPLICATION = DotName.createSimple((String)Application.class.getName());
    public static final String JAXRS_SCAN = "jaxrs.scan";
    public static final String JAXRS_SCAN_PROVIDERS = "jaxrs.scan.providers";
    public static final String JAXRS_SCAN_RESOURCES = "jaxrs.scan.resources";
    public static final Set<String> BOOT_CLASSES = new HashSet<String>();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Map deploymentData;
        DeploymentUnit parent;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        DeploymentUnit deploymentUnit2 = parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        if (deploymentUnit.getParent() == null) {
            deploymentData = Collections.synchronizedMap(new HashMap());
            deploymentUnit.putAttachment(JaxrsAttachments.ADDITIONAL_JAXRS_DEPLOYMENT_DATA, (Object)deploymentData);
        } else {
            deploymentData = (Map)parent.getAttachment(JaxrsAttachments.ADDITIONAL_JAXRS_DEPLOYMENT_DATA);
        }
        ModuleIdentifier moduleIdentifier = (ModuleIdentifier)deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
        JAXRSDeploymentMetadata jaxrsDeploymentData = new JAXRSDeploymentMetadata();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        try {
            if (warMetaData == null) {
                jaxrsDeploymentData.setScanAll(true);
                this.scan(deploymentUnit, (ClassLoader)module.getClassLoader(), jaxrsDeploymentData);
                deploymentData.put(moduleIdentifier, jaxrsDeploymentData);
            } else {
                this.scanWebDeployment(deploymentUnit, warMetaData.getMergedJBossWebMetaData(), (ClassLoader)module.getClassLoader(), jaxrsDeploymentData);
                this.scan(deploymentUnit, (ClassLoader)module.getClassLoader(), jaxrsDeploymentData);
            }
            deploymentUnit.putAttachment(JaxrsAttachments.JAXRS_DEPLOYMENT_DATA, (Object)jaxrsDeploymentData);
        }
        catch (ModuleLoadException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected void scanWebDeployment(DeploymentUnit du, JBossWebMetaData webdata, ClassLoader classLoader, JAXRSDeploymentMetadata jaxrsDeploymentData) throws DeploymentUnitProcessingException {
        List contextParams;
        boolean hasBoot = this.hasBootClasses(webdata);
        jaxrsDeploymentData.setBootClasses(hasBoot);
        Class<?> declaredApplicationClass = this.checkDeclaredApplicationClassAsServlet(webdata, classLoader);
        if (declaredApplicationClass != null) {
            jaxrsDeploymentData.setDispatcherCreated(true);
        }
        if (!hasBoot && !webdata.isMetadataComplete()) {
            jaxrsDeploymentData.setScanAll(true);
            jaxrsDeploymentData.setScanProviders(true);
            jaxrsDeploymentData.setScanResources(true);
        }
        if ((contextParams = webdata.getContextParams()) != null) {
            for (ParamValueMetaData param : contextParams) {
                if (param.getParamName().equals(JAXRS_SCAN)) {
                    jaxrsDeploymentData.setScanAll(this.valueOf(JAXRS_SCAN, param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals(JAXRS_SCAN_PROVIDERS)) {
                    jaxrsDeploymentData.setScanProviders(this.valueOf(JAXRS_SCAN_PROVIDERS, param.getParamValue()));
                    continue;
                }
                if (!param.getParamName().equals(JAXRS_SCAN_RESOURCES)) continue;
                jaxrsDeploymentData.setScanResources(this.valueOf(JAXRS_SCAN_RESOURCES, param.getParamValue()));
            }
        }
    }

    protected void scan(DeploymentUnit du, ClassLoader classLoader, JAXRSDeploymentMetadata jaxrsDeploymentData) throws DeploymentUnitProcessingException, ModuleLoadException {
        ClassInfo info;
        CompositeIndex index = (CompositeIndex)du.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (!jaxrsDeploymentData.shouldScan()) {
            return;
        }
        if (!jaxrsDeploymentData.isDispatcherCreated()) {
            Set applicationClasses = index.getAllKnownSubclasses(APPLICATION);
            try {
                for (ClassInfo c : applicationClasses) {
                    if (Modifier.isAbstract(c.flags())) continue;
                    Class<?> scanned = classLoader.loadClass(c.name().toString());
                    jaxrsDeploymentData.getScannedApplicationClasses().add(scanned);
                }
            }
            catch (ClassNotFoundException e) {
                throw JaxrsLogger.JAXRS_LOGGER.cannotLoadApplicationClass(e);
            }
        }
        List resources = null;
        List providers = null;
        if (jaxrsDeploymentData.isScanResources()) {
            resources = index.getAnnotations(JaxrsAnnotations.PATH.getDotName());
        }
        if (jaxrsDeploymentData.isScanProviders()) {
            providers = index.getAnnotations(JaxrsAnnotations.PROVIDER.getDotName());
        }
        if ((resources == null || resources.isEmpty()) && (providers == null || providers.isEmpty())) {
            return;
        }
        HashSet<ClassInfo> pathInterfaces = new HashSet<ClassInfo>();
        if (resources != null) {
            for (AnnotationInstance e : resources) {
                if (!(e.target() instanceof ClassInfo)) {
                    if (e.target() instanceof MethodInfo) continue;
                    JaxrsLogger.JAXRS_LOGGER.classOrMethodAnnotationNotFound("@Path", e.target());
                    continue;
                }
                info = (ClassInfo)e.target();
                if (info.annotations().containsKey(DECORATOR)) continue;
                if (!Modifier.isInterface(info.flags())) {
                    jaxrsDeploymentData.getScannedResourceClasses().add(info.name().toString());
                    continue;
                }
                pathInterfaces.add(info);
            }
        }
        if (providers != null) {
            for (AnnotationInstance e : providers) {
                if (e.target() instanceof ClassInfo) {
                    info = (ClassInfo)e.target();
                    if (info.annotations().containsKey(DECORATOR) || Modifier.isInterface(info.flags())) continue;
                    jaxrsDeploymentData.getScannedProviderClasses().add(info.name().toString());
                    continue;
                }
                JaxrsLogger.JAXRS_LOGGER.classAnnotationNotFound("@Provider", e.target());
            }
        }
        for (ClassInfo iface : pathInterfaces) {
            Set implementors = index.getAllKnownImplementors(iface.name());
            for (ClassInfo implementor : implementors) {
                if (implementor.annotations().containsKey(DECORATOR)) continue;
                jaxrsDeploymentData.getScannedResourceClasses().add(implementor.name().toString());
            }
        }
    }

    protected boolean hasBootClasses(JBossWebMetaData webdata) throws DeploymentUnitProcessingException {
        if (webdata.getServlets() != null) {
            for (ServletMetaData servlet : webdata.getServlets()) {
                String servletClass = servlet.getServletClass();
                if (!BOOT_CLASSES.contains(servletClass)) continue;
                return true;
            }
        }
        if (webdata.getFilters() != null) {
            for (FilterMetaData filter : webdata.getFilters()) {
                if (!BOOT_CLASSES.contains(filter.getFilterClass())) continue;
                return true;
            }
        }
        return false;
    }

    protected Class<?> checkDeclaredApplicationClassAsServlet(JBossWebMetaData webData, ClassLoader classLoader) throws DeploymentUnitProcessingException {
        if (webData.getServlets() == null) {
            return null;
        }
        for (ServletMetaData servlet : webData.getServlets()) {
            String servletClass = servlet.getServletClass();
            if (servletClass == null) continue;
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(servletClass);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
            if (!Application.class.isAssignableFrom(clazz)) continue;
            this.setJBossWSServlet(servlet);
            servlet.setAsyncSupported(true);
            this.setServletInitParam(servlet, "javax.ws.rs.Application", servletClass);
            return clazz;
        }
        return null;
    }

    private void setJBossWSServlet(ServletMetaData servlet) {
        servlet.setServletClass(WSFServlet.class.getName());
        this.setServletInitParam(servlet, "org.jboss.wsf.spi.deployment.jaxrsServletMode", "true");
        this.setServletInitParam(servlet, "org.jboss.wsf.spi.deployment.stackServletDelegateClass", "org.jboss.wsf.stack.cxf.JAXRSServletExt");
    }

    protected void setServletInitParam(ServletMetaData servlet, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = servlet.getInitParam();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            servlet.setInitParam(params);
        }
        params.add(param);
    }

    private boolean valueOf(String paramName, String value) throws DeploymentUnitProcessingException {
        if (value == null) {
            throw JaxrsLogger.JAXRS_LOGGER.invalidParamValue(paramName, value);
        }
        if (value.toLowerCase(Locale.ENGLISH).equals("true")) {
            return true;
        }
        if (value.toLowerCase(Locale.ENGLISH).equals("false")) {
            return false;
        }
        throw JaxrsLogger.JAXRS_LOGGER.invalidParamValue(paramName, value);
    }

    static {
        Collections.addAll(BOOT_CLASSES, WSFServlet.class.getName());
    }
}

