/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.spi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.xml.ws.spi.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ProviderLoader {
    ProviderLoader() {
    }

    public static Provider loadProvider(String defaultFactory) {
        PrivilegedAction action;
        String javaHome;
        File jaxmFile;
        Class<?> factoryClass;
        Object factory = null;
        String factoryName = null;
        ClassLoader loader = ProviderLoader.getContextClassLoader();
        String propertyName = "javax.xml.ws.spi.Provider";
        String filename = "META-INF/services/" + propertyName;
        InputStream inStream = ProviderLoader.getResourceAsStream(loader, filename);
        if (inStream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                factoryName = br.readLine();
                br.close();
                if (factoryName != null) {
                    factoryClass = ProviderLoader.loadClass(loader, factoryName);
                    factory = factoryClass.newInstance();
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && ((Boolean)AccessController.doPrivileged(new PropertyFileExistAction(jaxmFile = new File((javaHome = (String)AccessController.doPrivileged(action = new PropertyAccessAction("java.home"))) + "/lib/jaxws.properties")))).booleanValue()) {
            try {
                action = new PropertyFileAccessAction(jaxmFile.getCanonicalPath());
                Properties jaxmProperties = (Properties)AccessController.doPrivileged(action);
                factoryName = jaxmProperties.getProperty(propertyName);
                if (factoryName != null) {
                    Class<?> factoryClass2 = ProviderLoader.loadClass(loader, factoryName);
                    factory = factoryClass2.newInstance();
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && (factoryName = (String)AccessController.doPrivileged(action = new PropertyAccessAction(propertyName))) != null) {
            try {
                factoryClass = ProviderLoader.loadClass(loader, factoryName);
                factory = factoryClass.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && defaultFactory != null) {
            try {
                Class<?> factoryClass3 = ProviderLoader.loadClass(loader, defaultFactory);
                factory = factoryClass3.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load: " + defaultFactory, t);
            }
        }
        return factory;
    }

    private static Class<?> loadClass(final ClassLoader cl, final String name) throws PrivilegedActionException, ClassNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return cl.loadClass(name);
        }
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                try {
                    return cl.loadClass(name);
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
        });
    }

    private static InputStream getResourceAsStream(final ClassLoader cl, final String filename) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return cl.getResourceAsStream(filename);
        }
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return cl.getResourceAsStream(filename);
            }
        });
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static class PropertyFileExistAction
    implements PrivilegedAction {
        private File file;

        PropertyFileExistAction(File file) {
            this.file = file;
        }

        public Object run() {
            return this.file.exists();
        }
    }

    private static class PropertyFileAccessAction
    implements PrivilegedAction {
        private String filename;

        PropertyFileAccessAction(String filename) {
            this.filename = filename;
        }

        public Object run() {
            try {
                FileInputStream inStream = new FileInputStream(this.filename);
                Properties props = new Properties();
                props.load(inStream);
                return props;
            }
            catch (IOException ex) {
                throw new SecurityException("Cannot load properties: " + this.filename, ex);
            }
        }
    }

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;

        PropertyAccessAction(String name) {
            this.name = name;
        }

        public Object run() {
            return System.getProperty(this.name);
        }
    }
}

