/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.plugins.tools;

import java.io.File;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.jboss.ws.plugins.tools.AbstractToolsMojo;
import org.jboss.wsf.spi.tools.WSContractConsumer;

public abstract class AbstractWsConsumeMojo
extends AbstractToolsMojo {
    private List<String> wsdls;
    protected List<String> bindingFiles;
    private File catalog;
    protected File sourceDirectory;
    protected Boolean noCompile = true;
    protected String targetPackage;
    private String wsdlLocation;
    private String target;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (this.wsdls == null) {
            this.getLog().info((CharSequence)"No wsdl URL / file specified, nothing to do.");
            return;
        }
        if (this.verbose.booleanValue()) {
            log.info((CharSequence)"Classpath:");
            for (String s : this.getClasspathElements()) {
                log.info((CharSequence)(" " + s));
            }
        }
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getMavenClasspathAwareClassLoader(origLoader));
            WSContractConsumer consumer = WSContractConsumer.newInstance();
            this.setupConsumer(consumer);
            for (String wsdl : this.wsdls) {
                try {
                    consumer.consume(wsdl);
                }
                catch (MalformedURLException mue) {
                    log.error((CharSequence)("Skipping invalid wsdl reference: " + wsdl));
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error while running wsconsume", e);
                }
            }
            this.updateProjectSourceRoots();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private void setupConsumer(WSContractConsumer consumer) {
        consumer.setAdditionalCompilerClassPath(new LinkedList<String>(this.getClasspathElements()));
        consumer.setMessageStream(System.out);
        if (this.bindingFiles != null && !this.bindingFiles.isEmpty()) {
            LinkedList<File> files = new LinkedList<File>();
            for (String bf : this.bindingFiles) {
                files.add(new File(bf));
            }
            consumer.setBindingFiles(files);
        }
        if (this.catalog != null) {
            consumer.setCatalog(this.catalog);
        }
        consumer.setExtension(this.extension.booleanValue());
        consumer.setGenerateSource(this.generateSource.booleanValue());
        consumer.setNoCompile(this.noCompile.booleanValue());
        File outputDir = this.getOutputDirectory();
        if (outputDir != null) {
            consumer.setOutputDirectory(outputDir);
        }
        if (this.sourceDirectory != null) {
            consumer.setSourceDirectory(this.sourceDirectory);
        }
        if (this.target != null) {
            consumer.setTarget(this.target);
        }
        if (this.targetPackage != null) {
            consumer.setTargetPackage(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            consumer.setWsdlLocation(this.wsdlLocation);
        }
    }

    public List<String> getWsdls() {
        return this.wsdls;
    }

    public List<String> getBindingFiles() {
        return this.bindingFiles;
    }

    public File getCatalog() {
        return this.catalog;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public String getTarget() {
        return this.target;
    }
}

