/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.undertow_httpspi;

import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UndertowHeaderMap
implements Map<String, List<String>> {
    private HeaderMap headerMap;

    public UndertowHeaderMap(HeaderMap headerMap) {
        this.headerMap = headerMap;
    }

    @Override
    public int size() {
        return this.headerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headerMap.size() > 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.headerMap.contains(key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        for (HeaderValues values : this.headerMap) {
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> get(Object key) {
        HeaderValues values = this.headerMap.get(key.toString());
        ArrayList<String> result = new ArrayList<String>();
        if (values != null) {
            for (String value : values.toArray()) {
                result.add(value);
            }
        }
        return result;
    }

    @Override
    public List<String> put(String key, List<String> value) {
        Object previous = this.get(key);
        if (previous.isEmpty()) {
            previous = null;
        }
        this.headerMap.addAll(new HttpString(key), value);
        return previous;
    }

    @Override
    public List<String> remove(Object key) {
        Object previous = this.get(key);
        if (previous.isEmpty()) {
            previous = null;
        }
        this.headerMap.remove(key.toString());
        return previous;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> m) {
        for (String string : m.keySet()) {
            this.headerMap.putAll(new HttpString(string), (Collection)m.get(string));
        }
    }

    @Override
    public void clear() {
        this.headerMap.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> result = new HashSet<String>();
        for (HeaderValues value : this.headerMap) {
            result.add(value.getHeaderName().toString());
        }
        return result;
    }

    @Override
    public Collection<List<String>> values() {
        ArrayList<List<String>> collections = new ArrayList<List<String>>();
        for (HeaderValues value : this.headerMap) {
            ArrayList<String> values = new ArrayList<String>();
            for (String headerValue : value) {
                values.add(headerValue);
            }
            collections.add(values);
        }
        return collections;
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        HashSet<Map.Entry<String, List<String>>> result = new HashSet<Map.Entry<String, List<String>>>();
        for (HeaderValues headerValues : this.headerMap) {
            final String key = headerValues.getHeaderName().toString();
            final ArrayList<String> headerValueList = new ArrayList<String>();
            for (String value : headerValues) {
                headerValueList.add(value);
            }
            result.add(new Map.Entry<String, List<String>>(){

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public List<String> getValue() {
                    return headerValueList;
                }

                @Override
                public List<String> setValue(List<String> value) {
                    HeaderValues previous = UndertowHeaderMap.this.headerMap.get(key);
                    if (previous.isEmpty()) {
                        previous = null;
                    }
                    UndertowHeaderMap.this.headerMap.addAll(new HttpString(key), value);
                    return previous;
                }
            });
        }
        return result;
    }
}

