/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.archive;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.archive.ArchiveWorkItemHandler;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

public class ArchiveWorkitemHandlerTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testNoFilesSpecified() {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Archive", (Object)"testfile.txt");
        workItem.setParameter("Files", new ArrayList());
        ArchiveWorkItemHandler archiveWorkItemHandler = new ArchiveWorkItemHandler();
        archiveWorkItemHandler.setLogThrownException(true);
        archiveWorkItemHandler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertEquals((long)1L, (long)manager.getAbortedWorkItems().size());
        Assert.assertTrue((boolean)manager.getAbortedWorkItems().contains(workItem.getId()));
    }

    @Test
    public void testWithTempFile() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(123L);
        File tempFile = this.tempFolder.newFile("tempFile1.txt");
        FileUtils.writeStringToFile((File)tempFile, (String)"temp file content", (String)"UTF-8");
        File tempFileTwo = this.tempFolder.newFile("tempFile2.txt");
        FileUtils.writeStringToFile((File)tempFileTwo, (String)"temp file2 content", (String)"UTF-8");
        ArrayList<File> filesList = new ArrayList<File>();
        filesList.add(tempFile);
        filesList.add(tempFileTwo);
        workItem.setParameter("Archive", (Object)"testfile.txt");
        workItem.setParameter("Files", filesList);
        ArchiveWorkItemHandler archiveWorkItemHandler = new ArchiveWorkItemHandler();
        archiveWorkItemHandler.setLogThrownException(true);
        archiveWorkItemHandler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testNoArchiveSpecified() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Files", new ArrayList());
        ArchiveWorkItemHandler archiveWorkItemHandler = new ArchiveWorkItemHandler();
        archiveWorkItemHandler.setLogThrownException(true);
        archiveWorkItemHandler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertEquals((long)1L, (long)manager.getAbortedWorkItems().size());
        Assert.assertTrue((boolean)manager.getAbortedWorkItems().contains(workItem.getId()));
    }
}

