/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.camel;

import java.io.File;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.RunScript;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.workitem.camel.SQLCamelWorkitemHandler;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class CamelSqlTest {
    private static final String PROCESS_DEFINITION = "BPMN2-CamelSqlProcess.bpmn2";
    private SQLCamelWorkitemHandler handler;
    private HashMap<String, Object> context;
    private PoolingDataSource pds;

    @Before
    public void setup() throws Exception {
        DeleteDbFiles.execute((String)"~", (String)"jbpm-db-test", (boolean)true);
        CamelSqlTest.setupDb();
        PoolingDataSource ds = this.setupDataSource();
        SimpleRegistry simpleRegistry = new SimpleRegistry();
        simpleRegistry.put((Object)"jdbc/testDS1", (Object)ds);
        this.handler = new SQLCamelWorkitemHandler("queryResult", (CamelContext)new DefaultCamelContext((Registry)simpleRegistry));
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
    }

    @After
    public void cleanup() throws Exception {
        PersistenceUtil.cleanUp(this.context);
        DeleteDbFiles.execute((String)"~", (String)"jbpm-db-test", (boolean)true);
    }

    private static void setupDb() throws SQLException, URISyntaxException {
        File script = new File(CamelSqlTest.class.getResource("/init-db.sql").toURI());
        RunScript.execute((String)"jdbc:h2:mem:jbpm-db;MVCC=true", (String)"sa", (String)"", (String)script.getAbsolutePath(), (Charset)StandardCharsets.UTF_8, (boolean)false);
    }

    public PoolingDataSource setupDataSource() {
        this.pds = PersistenceUtil.setupPoolingDataSource((Properties)CamelSqlTest.getDefaultDSProperties(), (String)"jdbc/jbpm-ds", (boolean)false);
        this.pds.init();
        return this.pds;
    }

    private static Properties getDefaultDSProperties() {
        Properties defaultProperties = new Properties();
        String[] keyArr = new String[]{"serverName", "portNumber", "databaseName", "url", "user", "password", "driverClassName", "className", "maxPoolSize", "allowLocalTransactions"};
        String[] defaultPropArr = new String[]{"", "", "", "jdbc:h2:mem:jbpm-db;MVCC=true", "sa", "", "org.h2.Driver", "org.h2.jdbcx.JdbcDataSource", "16", "true"};
        Assert.assertTrue((String)"Unequal number of keys for default properties", (keyArr.length == defaultPropArr.length ? 1 : 0) != 0);
        for (int i = 0; i < keyArr.length; ++i) {
            defaultProperties.put(keyArr[i], defaultPropArr[i]);
        }
        return defaultProperties;
    }

    @Test
    public void testSelect() throws Exception {
        HashMap context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        Environment env = PersistenceUtil.createEnvironment((Map)context);
        KieBase kbase = this.createBase();
        StatefulKnowledgeSession kieSession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        kieSession.getWorkItemManager().registerWorkItemHandler("CamelSql", (WorkItemHandler)this.handler);
        String sqlQuery = "select NAME from TEST";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Query", sqlQuery);
        params.put("DataSource", "jdbc/testDS1");
        WorkflowProcessInstance wpi = (WorkflowProcessInstance)kieSession.startProcess("camelSqlProcess", params);
        Assert.assertEquals((long)2L, (long)((RuleFlowProcessInstance)wpi).getVariables().size());
        kieSession.dispose();
    }

    private KieBase createBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)PROCESS_DEFINITION), ResourceType.BPMN2);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        return kbuilder.newKieBase();
    }
}

