/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.camel;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.drools.core.process.instance.impl.DefaultWorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.workitem.camel.FileCamelWorkitemHandler;
import org.jbpm.test.AbstractBaseTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class CamelFileTest
extends AbstractBaseTest {
    private static final String PROCESS_DEFINITION = "BPMN2-CamelFileProcess.bpmn2";
    private static File tempDir;
    private static File testDir;
    private static File testFile;

    @BeforeClass
    public static void initialize() {
        tempDir = new File(System.getProperty("java.io.tmpdir"));
        testDir = new File(tempDir, "test_dir");
        String fileName = "test_file_" + CamelFileTest.class.getName() + "_" + UUID.randomUUID().toString();
        testFile = new File(tempDir, fileName);
    }

    @AfterClass
    public static void clean() throws IOException {
        FileUtils.deleteDirectory((File)testDir);
    }

    @Test
    public void testSingleFileProcess() throws IOException {
        String testData = "test-data";
        HashMap context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        Environment env = PersistenceUtil.createEnvironment((Map)context);
        KieBase kbase = this.createBase();
        StatefulKnowledgeSession kieSession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        kieSession.getWorkItemManager().registerWorkItemHandler("CamelFile", (WorkItemHandler)new FileCamelWorkitemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("payloadVar", "test-data");
        params.put("pathVar", tempDir.getAbsolutePath());
        params.put("fileNameVar", testFile.getName());
        ProcessInstance pi = kieSession.startProcess("camelFileProcess", params);
        ProcessInstance result = kieSession.getProcessInstance(pi.getId());
        Assert.assertNull((Object)result);
        Assert.assertTrue((String)"Expected file does not exist.", (boolean)testFile.exists());
        String resultText = FileUtils.readFileToString((File)testFile);
        Assert.assertEquals((Object)resultText, (Object)"test-data");
    }

    @Test
    public void testSingleFileWithHeaders() throws IOException {
        HashSet<String> headers = new HashSet<String>();
        headers.add("CamelFileName");
        FileCamelWorkitemHandler handler = new FileCamelWorkitemHandler(headers);
        handler.setLogThrownException(true);
        String testData = "test-data";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("path", (Object)tempDir.getAbsolutePath());
        workItem.setParameter("payload", (Object)"test-data");
        workItem.setParameter("CamelFileName", (Object)testFile.getName());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertTrue((String)"Expected file does not exist.", (boolean)testFile.exists());
        String resultText = FileUtils.readFileToString((File)testFile);
        Assert.assertEquals((Object)resultText, (Object)"test-data");
    }

    private KieBase createBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)PROCESS_DEFINITION), ResourceType.BPMN2);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        return kbuilder.newKieBase();
    }
}

