/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.camel;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.drools.core.process.instance.impl.DefaultWorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.camel.CamelFtpBaseTest;
import org.jbpm.process.workitem.camel.FTPSCamelWorkitemHandler;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

public class CamelFtpsTest
extends CamelFtpBaseTest {
    private static final String CLIENT_SSL_STORE_PASSWD = "passwd";
    private static final String SERVER_SSL_STORE_PASSWD = "passwd";
    private static final String CLIENT_SSL_KEY_PASSWD = "passwd";
    private static final String SERVER_SSL_KEY_PASSWD = "passwd";
    private static File SERVER_SSL_KEY_TRUST_STORE;
    private static File CLIENT_SSL_KEY_TRUST_STORE;

    @BeforeClass
    public static void setupKeyTrustStores() throws URISyntaxException {
        CLIENT_SSL_KEY_TRUST_STORE = new File(CamelFtpsTest.class.getResource("/ssl/client.jks").toURI());
        SERVER_SSL_KEY_TRUST_STORE = new File(CamelFtpsTest.class.getResource("/ssl/server.jks").toURI());
    }

    @Test
    public void testFtps() throws IOException {
        FTPSCamelWorkitemHandler handler = new FTPSCamelWorkitemHandler();
        handler.setLogThrownException(true);
        String testData = "test-data";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("username", (Object)"testUser");
        workItem.setParameter("password", (Object)"testPasswd");
        workItem.setParameter("hostname", (Object)"localhost");
        workItem.setParameter("port", (Object)PORT.toString());
        workItem.setParameter("directoryname", (Object)this.testFile.getParentFile().getName());
        workItem.setParameter("CamelFileName", (Object)this.testFile.getName());
        workItem.setParameter("payload", (Object)"test-data");
        workItem.setParameter("isImplicit", (Object)"true");
        workItem.setParameter("securityProtocol", (Object)"TLS");
        workItem.setParameter("ftpClient.trustStore.file", (Object)CLIENT_SSL_KEY_TRUST_STORE.getAbsolutePath());
        workItem.setParameter("ftpClient.trustStore.password", (Object)"passwd");
        workItem.setParameter("ftpClient.trustStore.keyPassword", (Object)"passwd");
        workItem.setParameter("ftpClient.keyStore.file", (Object)CLIENT_SSL_KEY_TRUST_STORE.getAbsolutePath());
        workItem.setParameter("ftpClient.keyStore.password", (Object)"passwd");
        workItem.setParameter("ftpClient.keyStore.keyPassword", (Object)"passwd");
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertTrue((String)"Expected file does not exist.", (boolean)this.testFile.exists());
        String resultText = FileUtils.readFileToString((File)this.testFile);
        Assert.assertEquals((Object)resultText, (Object)"test-data");
    }

    @Override
    protected FtpServer configureFtpServer(CamelFtpBaseTest.FtpServerBuilder builder) throws FtpException {
        ListenerFactory listenerFactory = this.configureSSL();
        return builder.addUser("testUser", "testPasswd", this.ftpRoot, true).registerDefaultListener(listenerFactory.createListener()).build();
    }

    private ListenerFactory configureSSL() {
        ListenerFactory listener = new ListenerFactory();
        listener.setServerAddress("127.0.0.1");
        listener.setPort(PORT.intValue());
        SslConfigurationFactory ssl = new SslConfigurationFactory();
        ssl.setKeystoreFile(SERVER_SSL_KEY_TRUST_STORE);
        ssl.setKeyPassword("passwd");
        ssl.setKeystorePassword("passwd");
        ssl.setTruststoreFile(SERVER_SSL_KEY_TRUST_STORE);
        ssl.setTruststorePassword("passwd");
        ssl.setClientAuthentication("NEED");
        SslConfiguration sslConfig = ssl.createSslConfiguration();
        listener.setSslConfiguration(sslConfig);
        listener.setImplicitSsl(true);
        DataConnectionConfigurationFactory dataConfigFactory = new DataConnectionConfigurationFactory();
        dataConfigFactory.setImplicitSsl(true);
        listener.setDataConnectionConfiguration(dataConfigFactory.createDataConnectionConfiguration());
        return listener;
    }
}

