/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.camel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.usermanager.UserFactory;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.jbpm.process.workitem.camel.CamelFtpTest;
import org.jbpm.test.AbstractBaseTest;
import org.junit.After;
import org.junit.Before;

public abstract class CamelFtpBaseTest
extends AbstractBaseTest {
    protected static final String USER = "testUser";
    protected static final String PASSWD = "testPasswd";
    protected static final String HOST = "localhost";
    protected static final Integer PORT = 2221;
    protected File ftpRoot;
    protected File testFile;
    protected FtpServer server;

    @Before
    public void initialize() throws FtpException, IOException {
        boolean created;
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        this.ftpRoot = new File(tempDir, "ftp");
        if (this.ftpRoot.exists()) {
            FileUtils.deleteDirectory((File)this.ftpRoot);
        }
        if (!(created = this.ftpRoot.mkdir())) {
            throw new IllegalArgumentException("FTP root directory has not been created, check system property java.io.tmpdir");
        }
        String fileName = "test_file_" + CamelFtpTest.class.getName() + "_" + UUID.randomUUID().toString();
        File testDir = new File(this.ftpRoot, "testDirectory");
        this.testFile = new File(testDir, fileName);
        this.server = this.configureFtpServer(new FtpServerBuilder());
        this.server.start();
    }

    @After
    public void clean() throws IOException {
        if (this.server != null && !this.server.isStopped()) {
            this.server.stop();
        }
    }

    protected abstract FtpServer configureFtpServer(FtpServerBuilder var1) throws FtpException;

    protected class FtpServerBuilder {
        private FtpServerFactory ftpServerFactory = new FtpServerFactory();

        public FtpServerBuilder registerListener(String listenerName, Listener listener) {
            this.ftpServerFactory.addListener(listenerName, listener);
            return this;
        }

        public FtpServerBuilder registerDefaultListener(Listener listener) {
            return this.registerListener("default", listener);
        }

        public FtpServerBuilder addUser(String username, String password, File home, boolean write) throws FtpException {
            UserFactory userFactory = new UserFactory();
            userFactory.setHomeDirectory(home.getAbsolutePath());
            userFactory.setName(username);
            userFactory.setPassword(password);
            if (write) {
                ArrayList<WritePermission> authorities = new ArrayList<WritePermission>();
                WritePermission writePermission = new WritePermission();
                authorities.add(writePermission);
                userFactory.setAuthorities(authorities);
            }
            User user = userFactory.createUser();
            this.ftpServerFactory.getUserManager().save(user);
            return this;
        }

        public FtpServer build() {
            return this.ftpServerFactory.createServer();
        }

        public FtpServerFactory getFtpServerFactory() {
            return this.ftpServerFactory;
        }
    }
}

