/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.camel;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.jbpm.process.workitem.camel.CamelContextService;
import org.jbpm.process.workitem.camel.request.RequestMapper;
import org.jbpm.process.workitem.camel.response.ResponseMapper;
import org.jbpm.process.workitem.camel.uri.URIMapper;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCamelWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    static final Logger logger = LoggerFactory.getLogger(AbstractCamelWorkitemHandler.class);
    protected ResponseMapper responseMapper;
    protected RequestMapper requestMapper;
    protected URIMapper uriConverter;
    protected CamelContext context;

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            manager.completeWorkItem(workItem.getId(), this.send(workItem));
        }
        catch (Exception e) {
            logger.error("Error executing workitem: " + e.getMessage());
            this.handleException(e);
        }
    }

    private Map<String, Object> send(WorkItem workItem) throws URISyntaxException {
        String s;
        if (this.context == null) {
            this.context = CamelContextService.getInstance();
        }
        ProducerTemplate template = this.context.createProducerTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>(workItem.getParameters());
        params.remove("TaskName");
        Processor processor = this.requestMapper.mapToRequest(params);
        URI uri = this.uriConverter.toURI(params);
        try {
            s = URLDecoder.decode(uri.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            s = uri.toString();
        }
        Endpoint endpoint = this.context.getEndpoint(s);
        Exchange exchange = template.send(endpoint, processor);
        return this.responseMapper.mapFromResponse(exchange);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    protected void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }
}

