/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.camel;

import java.io.File;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.RunScript;
import org.jbpm.process.workitem.camel.SQLCamelWorkitemHandler;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class CamelSqlTest {
    private static final String PROCESS_DEFINITION = "BPMN2-CamelSqlProcess.bpmn2";
    private SQLCamelWorkitemHandler handler;
    private HashMap<String, Object> context;

    @Before
    public void setup() throws Exception {
        DeleteDbFiles.execute((String)"~", (String)"jbpm-db-test", (boolean)true);
        CamelSqlTest.setupDb();
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.contrib.camel-workitem");
        SimpleRegistry simpleRegistry = new SimpleRegistry();
        simpleRegistry.put((Object)"jdbc/testDS1", this.context.get("org.droolsjbpm.persistence.datasource"));
        this.handler = new SQLCamelWorkitemHandler("queryResult", (CamelContext)new DefaultCamelContext((Registry)simpleRegistry));
    }

    @After
    public void cleanup() {
        PersistenceUtil.cleanUp(this.context);
        DeleteDbFiles.execute((String)"~", (String)"jbpm-db-test", (boolean)true);
    }

    private static void setupDb() throws SQLException, URISyntaxException {
        File script = new File(CamelSqlTest.class.getResource("/init-db.sql").toURI());
        RunScript.execute((String)"jdbc:h2:mem:jbpm-db;MVCC=true", (String)"sa", (String)"", (String)script.getAbsolutePath(), (Charset)StandardCharsets.UTF_8, (boolean)false);
    }

    @Test
    public void testSelect() {
        Environment env = PersistenceUtil.createEnvironment(this.context);
        KieBase kbase = this.createBase();
        StatefulKnowledgeSession kieSession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        kieSession.getWorkItemManager().registerWorkItemHandler("CamelSql", (WorkItemHandler)this.handler);
        String sqlQuery = "select NAME from TEST";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Query", sqlQuery);
        params.put("DataSource", "jdbc/testDS1");
        WorkflowProcessInstance wpi = (WorkflowProcessInstance)kieSession.startProcess("camelSqlProcess", params);
        Assert.assertEquals((long)2L, (long)((RuleFlowProcessInstance)wpi).getVariables().size());
        kieSession.dispose();
    }

    private KieBase createBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)PROCESS_DEFINITION), ResourceType.BPMN2);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        return kbuilder.newKieBase();
    }
}

