/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.docker;

import com.github.dockerjava.api.DockerClient;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.docker.DockerClientConnector;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="DockerStopContainerDefinitions.wid", name="DockerStopContainer", displayName="DockerStopContainer", defaultHandler="mvel: new org.jbpm.process.workitem.docker.StopContainerWorkitemHandler()", documentation="docker-workitem/index.html", category="docker-workitem", icon="DockerStopContainer.png", parameters={@WidParameter(name="ContainerId", required=true)}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="docker-workitem", version="7.32.0.Final")}, serviceInfo=@WidService(category="Docker", description="Connect to and interact with a running Docker deamon", keywords="Docker,stop,container", action=@WidAction(title="Stop Docker container")))
public class StopContainerWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(StopContainerWorkitemHandler.class);
    private DockerClient dockerClient;

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String containerId = (String)workItem.getParameter("ContainerId");
            if (this.dockerClient == null) {
                DockerClientConnector connector = new DockerClientConnector();
                this.dockerClient = connector.getDockerClient();
            }
            this.dockerClient.stopContainerCmd(containerId).exec();
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            logger.error("Unable to stop container: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
    }
}

