/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.ListContainersCmd;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.docker.DockerClientConnector;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="DockerListContainersDefinitions.wid", name="DockerListContainers", displayName="DockerListContainers", defaultHandler="mvel: new org.jbpm.process.workitem.docker.ListContainersWorkitemHandler()", documentation="docker-workitem/index.html", category="docker-workitem", icon="DockerListContainers.png", parameters={@WidParameter(name="StatusFilter")}, results={@WidResult(name="Containers", runtimeType="java.util.List")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="docker-workitem", version="7.70.0.Final")}, serviceInfo=@WidService(category="Docker", description="Connect to and interact with a running Docker deamon", keywords="Docker,list,containers", action=@WidAction(title="List Docker containers")))
public class ListContainersWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(ListContainersWorkitemHandler.class);
    private static final String RESULTS_DOCUMENT = "Containers";
    private DockerClient dockerClient;

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap<String, List> results = new HashMap<String, List>();
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String statusFilter = (String)workItem.getParameter("StatusFilter");
            if (this.dockerClient == null) {
                DockerClientConnector connector = new DockerClientConnector();
                this.dockerClient = connector.getDockerClient();
            }
            ListContainersCmd listContainersCmd = this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).withShowSize(Boolean.valueOf(true));
            if (statusFilter != null && statusFilter.trim().length() > 0) {
                listContainersCmd = listContainersCmd.withStatusFilter(Collections.singletonList(statusFilter));
            }
            List containers = (List)listContainersCmd.exec();
            results.put(RESULTS_DOCUMENT, containers);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Unable to get list of containers: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
    }
}

