/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.docker.CreateContainerWorkitemHandler;
import org.jbpm.process.workitem.docker.InspectContainerWorkitemHandler;
import org.jbpm.process.workitem.docker.KillContainerWorkitemHandler;
import org.jbpm.process.workitem.docker.ListContainersWorkitemHandler;
import org.jbpm.process.workitem.docker.ListImagesWorkitemHandler;
import org.jbpm.process.workitem.docker.StartContainerWorkitemHandler;
import org.jbpm.process.workitem.docker.StopContainerWorkitemHandler;
import org.jbpm.process.workitem.docker.responses.SerializableInspectContainerResponse;
import org.jbpm.test.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DockerWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    DockerClient dockerClient;
    @Mock
    CreateContainerCmd createContainerCmd;
    @Mock
    CreateContainerResponse createContainerResponse;
    @Mock
    InspectContainerCmd inspectContainerCmd;
    @Mock
    InspectContainerResponse inspectContainerResponse;
    @Mock
    KillContainerCmd killContainerCmd;
    @Mock
    ListContainersCmd listContainersCmd;
    @Mock
    ListImagesCmd listImagesCmd;
    @Mock
    StartContainerCmd startContainerCmd;
    @Mock
    StopContainerCmd stopContainerCmd;

    @Before
    public void setUp() {
        try {
            ArrayList testContainers = new ArrayList();
            ArrayList testImages = new ArrayList();
            Mockito.when((Object)this.dockerClient.createContainerCmd(Matchers.anyString())).thenReturn((Object)this.createContainerCmd);
            Mockito.when((Object)this.createContainerCmd.withName(Matchers.anyString())).thenReturn((Object)this.createContainerCmd);
            Mockito.when((Object)this.createContainerCmd.exec()).thenReturn((Object)this.createContainerResponse);
            Mockito.when((Object)this.createContainerResponse.getId()).thenReturn((Object)"1");
            Mockito.when((Object)this.dockerClient.inspectContainerCmd(Matchers.anyString())).thenReturn((Object)this.inspectContainerCmd);
            Mockito.when((Object)this.inspectContainerCmd.exec()).thenReturn((Object)this.inspectContainerResponse);
            Mockito.when((Object)this.dockerClient.killContainerCmd(Matchers.anyString())).thenReturn((Object)this.killContainerCmd);
            Mockito.when((Object)this.dockerClient.listContainersCmd()).thenReturn((Object)this.listContainersCmd);
            Mockito.when((Object)this.listContainersCmd.withShowAll((Boolean)Mockito.any(Boolean.class))).thenReturn((Object)this.listContainersCmd);
            Mockito.when((Object)this.listContainersCmd.withShowSize((Boolean)Mockito.any(Boolean.class))).thenReturn((Object)this.listContainersCmd);
            Mockito.when((Object)((List)this.listContainersCmd.exec())).thenReturn(testContainers);
            Mockito.when((Object)this.dockerClient.listImagesCmd()).thenReturn((Object)this.listImagesCmd);
            Mockito.when((Object)((List)this.listImagesCmd.exec())).thenReturn(testImages);
            Mockito.when((Object)this.dockerClient.startContainerCmd(Matchers.anyString())).thenReturn((Object)this.startContainerCmd);
            Mockito.when((Object)this.dockerClient.stopContainerCmd(Matchers.anyString())).thenReturn((Object)this.stopContainerCmd);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDockerCreateContainer() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ContainerName", (Object)"testContainerName");
        workItem.setParameter("ContainerImageName", (Object)"testContainerImageName");
        CreateContainerWorkitemHandler handler = new CreateContainerWorkitemHandler();
        handler.setDockerClient(this.dockerClient);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("ContainerId") instanceof String));
    }

    @Test
    public void testDockerInspectContainer() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ContainerId", (Object)"testContainerId");
        InspectContainerWorkitemHandler handler = new InspectContainerWorkitemHandler();
        handler.setDockerClient(this.dockerClient);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("ContainerInfo") instanceof SerializableInspectContainerResponse));
    }

    @Test
    public void testDockerKillContainer() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ContainerId", (Object)"testContainerId");
        KillContainerWorkitemHandler handler = new KillContainerWorkitemHandler();
        handler.setDockerClient(this.dockerClient);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testDockerListContainers() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        ListContainersWorkitemHandler handler = new ListContainersWorkitemHandler();
        handler.setDockerClient(this.dockerClient);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("Containers") instanceof List));
    }

    @Test
    public void testDockerListImages() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        ListImagesWorkitemHandler handler = new ListImagesWorkitemHandler();
        handler.setDockerClient(this.dockerClient);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("Images") instanceof List));
    }

    @Test
    public void testDockerStartContainer() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ContainerId", (Object)"testContainerId");
        StartContainerWorkitemHandler handler = new StartContainerWorkitemHandler();
        handler.setDockerClient(this.dockerClient);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testDockerStopContainer() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ContainerId", (Object)"testContainerId");
        StopContainerWorkitemHandler handler = new StopContainerWorkitemHandler();
        handler.setDockerClient(this.dockerClient);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }
}

