/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.dropbox;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.DownloadBuilder;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.UploadBuilder;
import com.dropbox.core.v2.files.WriteMode;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.document.Document;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.dropbox.DownloadFileWorkitemHandler;
import org.jbpm.process.workitem.dropbox.DropboxAuth;
import org.jbpm.process.workitem.dropbox.UploadFileWorkitemHandler;
import org.jbpm.test.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DropboxWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    DropboxAuth auth;
    @Mock
    DbxClientV2 client;
    @Mock
    DbxUserFilesRequests fileRequests;
    @Mock
    UploadBuilder uploadBuilder;
    @Mock
    FileMetadata metaData;
    @Mock
    DownloadBuilder downloadBuilder;
    @Mock
    DbxDownloader<FileMetadata> downloader;
    private Document testDoc;

    @Before
    public void setUp() {
        try {
            this.testDoc = new DocumentImpl();
            this.testDoc.setName("testDoc.txt");
            this.testDoc.setIdentifier("testDoc");
            this.testDoc.setLastModified(new Date());
            this.testDoc.setContent(new String("test doc content").getBytes());
            InputStream testInputStream = IOUtils.toInputStream((String)"test doc content", (String)"UTF-8");
            Mockito.when((Object)this.auth.authorize(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.client);
            Mockito.when((Object)this.client.files()).thenReturn((Object)this.fileRequests);
            Mockito.when((Object)this.fileRequests.uploadBuilder(Matchers.anyString())).thenReturn((Object)this.uploadBuilder);
            Mockito.when((Object)this.uploadBuilder.withMode((WriteMode)Mockito.any(WriteMode.class))).thenReturn((Object)this.uploadBuilder);
            Mockito.when((Object)this.uploadBuilder.withClientModified((Date)Mockito.any(Date.class))).thenReturn((Object)this.uploadBuilder);
            Mockito.when((Object)this.uploadBuilder.uploadAndFinish((InputStream)Mockito.any(InputStream.class))).thenReturn((Object)this.metaData);
            Mockito.when((Object)this.fileRequests.downloadBuilder(Matchers.anyString())).thenReturn((Object)this.downloadBuilder);
            Mockito.when((Object)this.downloadBuilder.start()).thenReturn(this.downloader);
            Mockito.when((Object)this.downloader.getInputStream()).thenReturn((Object)testInputStream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUploadFile() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Path", (Object)"/testpath");
        workItem.setParameter("Document", (Object)this.testDoc);
        UploadFileWorkitemHandler handler = new UploadFileWorkitemHandler("testClientID", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testUploadFileInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        UploadFileWorkitemHandler handler = new UploadFileWorkitemHandler("testClientID", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }

    @Test
    public void testDownloadFile() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("DocumentPath", (Object)"/testpath/testDocName.txt");
        DownloadFileWorkitemHandler handler = new DownloadFileWorkitemHandler("testClientID", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("Document") instanceof Document));
        Document downloadedDoc = (Document)((Map)manager.getResults().get(workItem.getId())).get("Document");
        Assert.assertNotNull((Object)downloadedDoc);
        Assert.assertEquals((Object)"testDocName.txt", (Object)downloadedDoc.getName());
        Assert.assertEquals((Object)"test doc content", (Object)new String(downloadedDoc.getContent()));
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testDownloadFileInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        DownloadFileWorkitemHandler handler = new DownloadFileWorkitemHandler("testClientID", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

