/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.dropbox;

import com.dropbox.core.v2.DbxClientV2;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.dropbox.DropboxAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="DropboxDownloadFileDefinitions.wid", name="DropboxDownloadFile", displayName="DropboxDownloadFile", defaultHandler="mvel: new org.jbpm.process.workitem.dropbox.DownloadFileWorkitemHandler(\"clientIdentifier\", \"accessToken\")", documentation="dropbox-workitem/index.html", category="dropbox-workitem", icon="DropboxDownloadFile.png", parameters={@WidParameter(name="DocumentPath", required=true)}, results={@WidResult(name="Document", runtimeType="org.jbpm.document.Document")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="dropbox-workitem", version="7.55.0.Final")}, serviceInfo=@WidService(category="Dropbox", description="Upload and download files from Dropbox", keywords="DropBox,file,files,download,document,documents", action=@WidAction(title="Upload a file to DropBox"), authinfo=@WidAuth(required=true, params={"clientIdentifier", "accessToken"}, paramsdescription={"Dropbox client identifier", "Dropbox access token"}, referencesite="https://www.dropbox.com/lp/developers")))
public class DownloadFileWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(DownloadFileWorkitemHandler.class);
    private static final String RESULTS_DOCUMENT = "Document";
    private DropboxAuth auth;
    private DbxClientV2 client;
    private String clientIdentifier;
    private String accessToken;

    public DownloadFileWorkitemHandler(String clientIdentifier, String accessToken) {
        this.clientIdentifier = clientIdentifier;
        this.accessToken = accessToken;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap<String, DocumentImpl> results = new HashMap<String, DocumentImpl>();
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            if (this.auth == null) {
                this.auth = new DropboxAuth();
            }
            this.client = this.auth.authorize(this.clientIdentifier, this.accessToken);
            String dropboxDocumentPath = (String)workItem.getParameter("DocumentPath");
            InputStream inStream = this.client.files().downloadBuilder(dropboxDocumentPath).start().getInputStream();
            Path path = Paths.get(dropboxDocumentPath, new String[0]);
            DocumentImpl doc = new DocumentImpl();
            doc.setName(path.getFileName().toString());
            doc.setIdentifier(dropboxDocumentPath);
            doc.setLastModified(new Date());
            doc.setContent(IOUtils.toByteArray((InputStream)inStream));
            results.put(RESULTS_DOCUMENT, doc);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Unable to download file: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(DropboxAuth auth) {
        this.auth = auth;
    }
}

