/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ethereum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.ethereum.EthereumAuth;
import org.jbpm.process.workitem.ethereum.EthereumUtils;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.http.HttpService;

@Wid(widfile="EthereumTransactExistingContract.wid", name="EthereumTransactExistingContract", displayName="EthereumTransactExistingContract", defaultHandler="mvel: new org.jbpm.process.workitem.ethereum.TransactExistingContractWorkitemHandler(\"walletPassword\", \"walletPath\")", documentation="ethereum-workitem/index.html", category="ethereum-workitem", icon="EthereumTransactExistingContract.png", parameters={@WidParameter(name="ServiceURL", required=true), @WidParameter(name="ContractAddress", required=true), @WidParameter(name="MethodName", required=true), @WidParameter(name="MethodInputType", runtimeType="org.web3j.abi.datatypes.Type"), @WidParameter(name="WaitForReceipt"), @WidParameter(name="DepositAmount")}, results={@WidResult(name="Receipt", runtimeType="org.web3j.protocol.core.methods.response.TransactionReceipt")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="ethereum-workitem", version="7.33.0.Final")}, serviceInfo=@WidService(category="Ethereum", description="Integrate with the Ethereum Blockchain app platform", keywords="Ethereum,blockchain,smart,contract,smartcontract,transaction,send", action=@WidAction(title="Perform a transaction to an existing contract on the blockchain"), authinfo=@WidAuth(required=true, params={"walletPassword", "walletPath"}, paramsdescription={"Wallet password", "Path to the wallet file"})))
public class TransactExistingContractWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String walletPassword;
    private String walletPath;
    private EthereumAuth auth;
    private Web3j web3j;
    private ClassLoader classLoader;
    private static final String RESULTS = "Receipt";
    private static final Logger logger = LoggerFactory.getLogger(TransactExistingContractWorkitemHandler.class);

    public TransactExistingContractWorkitemHandler(String walletPassword, String walletPath) {
        this(walletPassword, walletPath, null);
    }

    public TransactExistingContractWorkitemHandler(String walletPassword, String walletPath, ClassLoader classLoader) {
        this.walletPassword = walletPassword;
        this.walletPath = walletPath;
        this.classLoader = classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : classLoader;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String serviceURL = (String)workItem.getParameter("ServiceURL");
            String contractAddress = (String)workItem.getParameter("ContractAddress");
            String waitForReceiptStr = (String)workItem.getParameter("WaitForReceipt");
            String methodName = (String)workItem.getParameter("MethodName");
            Type methodInputType = (Type)workItem.getParameter("MethodInputType");
            String depositAmount = (String)workItem.getParameter("DepositAmount");
            HashMap<String, TransactionReceipt> results = new HashMap<String, TransactionReceipt>();
            if (this.web3j == null) {
                this.web3j = Web3j.build((Web3jService)new HttpService(serviceURL));
            }
            this.auth = new EthereumAuth(this.walletPassword, this.walletPath, this.classLoader);
            Credentials credentials = this.auth.getCredentials();
            int depositEtherAmountToSend = 0;
            if (depositAmount != null) {
                depositEtherAmountToSend = Integer.parseInt(depositAmount);
            }
            boolean waitForReceipt = false;
            if (waitForReceiptStr != null) {
                waitForReceipt = Boolean.parseBoolean(waitForReceiptStr);
            }
            ArrayList<Type> methodInputTypeList = new ArrayList();
            if (methodInputType != null) {
                methodInputTypeList = Collections.singletonList(methodInputType);
            }
            TransactionReceipt transactionReceipt = EthereumUtils.transactExistingContract(credentials, this.web3j, depositEtherAmountToSend, EthereumUtils.DEFAULT_GAS_PRICE, EthereumUtils.DEFAULT_GAS_LIMIT, contractAddress, methodName, methodInputTypeList, null, waitForReceipt, 15000, 40);
            results.put(RESULTS, transactionReceipt);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Error executing workitem: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setWeb3j(Web3j web3j) {
        this.web3j = web3j;
    }
}

