/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.exec;

import java.util.ArrayList;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.exec.ExecWorkItemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

public class ExecWorkItemHandlerTest {
    @Test
    public void testExecCommand() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Command", (Object)"java -version");
        ExecWorkItemHandler handler = new ExecWorkItemHandler();
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Output");
        Assert.assertEquals((Object)"[java, -version]", (Object)handler.getParsedCommandStr());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.contains("java version") || result.contains("jdk version") ? 1 : 0) != 0);
    }

    @Test
    public void testExecCommandWithArguments() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Command", (Object)"java");
        ArrayList<String> argumentList = new ArrayList<String>();
        argumentList.add("-version");
        workItem.setParameter("Arguments", argumentList);
        ExecWorkItemHandler handler = new ExecWorkItemHandler();
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Output");
        Assert.assertEquals((Object)"[java, -version]", (Object)handler.getParsedCommandStr());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.contains("java version") || result.contains("jdk version") ? 1 : 0) != 0);
    }

    @Test
    public void testExecCommandInvalidParam() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        ExecWorkItemHandler handler = new ExecWorkItemHandler();
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

