/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.exec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.exec.ExecShellScriptWorkItemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

public class ExecShellScriptWorkItemHandlerTest {
    @Test
    public void testExecShellScriptCommand() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ShellScriptLocation", (Object)"src/test/resources/TestScript.sh");
        ExecShellScriptWorkItemHandler handler = new ExecShellScriptWorkItemHandler();
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        List result = (List)results.get("Output");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.contains("Test Script Started") && result.contains("Test Script Ended") ? 1 : 0) != 0);
    }

    @Test
    public void testExecShellScriptCommandWithTimeout() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ShellScriptLocation", (Object)"src/test/resources/TestScript.sh");
        workItem.setParameter("TimeoutInMillis", (Object)"10");
        ExecShellScriptWorkItemHandler handler = new ExecShellScriptWorkItemHandler();
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        List result = (List)results.get("Output");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testExecShellScriptCommandWithAddEnvironmentVariables() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ShellScriptLocation", (Object)"src/test/resources/TestScript.sh");
        HashMap<String, String> envVariableList = new HashMap<String, String>();
        envVariableList.put("testVariable", "tested");
        workItem.setParameter("AddEnvironmentVariable", envVariableList);
        ExecShellScriptWorkItemHandler handler = new ExecShellScriptWorkItemHandler();
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        List result = (List)results.get("Output");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("tested"));
    }

    @Test
    public void testExecShellScriptCommandWithRemoveEnvironmentVariables() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ShellScriptLocation", (Object)"src/test/resources/TestScript.sh");
        HashMap<String, String> envVariableList = new HashMap<String, String>();
        envVariableList.put("newVariable", "variableRemoved");
        workItem.setParameter("AddEnvironmentVariable", envVariableList);
        ArrayList<String> removeEnvList = new ArrayList<String>();
        removeEnvList.add("newVariable");
        workItem.setParameter("RemoveEnvironmentVariable", removeEnvList);
        ExecShellScriptWorkItemHandler handler = new ExecShellScriptWorkItemHandler();
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        List result = (List)results.get("Output");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((!result.contains("variableRemoved") ? 1 : 0) != 0);
    }

    @Test
    public void testExecShellScriptCommandInvalidParam() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        ExecShellScriptWorkItemHandler handler = new ExecShellScriptWorkItemHandler();
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

