/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.executesql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.executesql.ExecuteSqlWorkItemHandler;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

public class ExecuteSqlWorkItemHandlerTest {
    private static final String DS_NAME = "executeSqlData";
    private static TestH2Server h2Server;

    @BeforeClass
    public static void configure() {
        try {
            ExecuteSqlWorkItemHandlerTest.setupPoolingDataSource();
            ExecuteSqlWorkItemHandlerTest.insertData();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @AfterClass
    public static void tearDown() {
        try {
            if (h2Server != null) {
                h2Server.finalize();
            }
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFetchAllRows() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("SQLStatement", (Object)"select * from Person");
        ExecuteSqlWorkItemHandler handler = new ExecuteSqlWorkItemHandler(DS_NAME);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("Result") instanceof List));
        List resultLines = (List)((Map)manager.getResults().get(workItem.getId())).get("Result");
        Assert.assertNotNull((Object)resultLines);
        Assert.assertEquals((long)3L, (long)resultLines.size());
    }

    @Test
    public void testFetchSpecificRow() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("SQLStatement", (Object)"select * from Person where id = 1");
        ExecuteSqlWorkItemHandler handler = new ExecuteSqlWorkItemHandler(DS_NAME);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        List resultLines = (List)((Map)manager.getResults().get(workItem.getId())).get("Result");
        Assert.assertNotNull((Object)resultLines);
        Assert.assertEquals((long)1L, (long)resultLines.size());
        Assert.assertEquals((Object)"1,Anthony,3", resultLines.get(0));
    }

    @Test
    public void testNoResults() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("SQLStatement", (Object)"select * from Person where id = 100");
        ExecuteSqlWorkItemHandler handler = new ExecuteSqlWorkItemHandler(DS_NAME);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        List resultLines = (List)((Map)manager.getResults().get(workItem.getId())).get("Result");
        Assert.assertNotNull((Object)resultLines);
        Assert.assertEquals((long)0L, (long)resultLines.size());
    }

    private static void insertData() throws Exception {
        DataSource ds = (DataSource)InitialContext.doLookup(DS_NAME);
        Connection connection = ds.getConnection();
        PreparedStatement createTableStatement = connection.prepareStatement("create table Person(id int, name varchar2(255), age int);");
        createTableStatement.executeUpdate();
        PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO Person ( id, name, age) VALUES (1, 'Anthony', 3), (2, 'Will', 30), (3, 'Moon', 28);");
        insertStatement.executeUpdate();
    }

    private static PoolingDataSource setupPoolingDataSource() throws Exception {
        h2Server = new TestH2Server();
        h2Server.start();
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName(DS_NAME);
        pds.setClassName("org.h2.jdbcx.JdbcDataSource");
        pds.getDriverProperties().put("user", "sa");
        pds.getDriverProperties().put("url", "jdbc:h2:mem:executeSql-data;MVCC=true");
        pds.getDriverProperties().put("driverClassName", "org.h2.Driver");
        pds.init();
        return pds;
    }

    private static class TestH2Server {
        private Server realH2Server;

        private TestH2Server() {
        }

        public void start() {
            if (this.realH2Server == null || !this.realH2Server.isRunning(false)) {
                try {
                    this.realH2Server = Server.createTcpServer((String[])new String[0]);
                    this.realH2Server.start();
                    System.out.println("Started H2 Server...");
                }
                catch (SQLException e) {
                    throw new RuntimeException("can't start h2 server db", e);
                }
            }
        }

        protected void finalize() throws Throwable {
            if (this.realH2Server != null) {
                System.out.println("Stopping H2 Server...");
                this.realH2Server.stop();
            }
            DeleteDbFiles.execute((String)"", (String)"target/executeSql-data", (boolean)true);
            super.finalize();
        }
    }
}

