/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ftp;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.email.Connection;
import org.jbpm.process.workitem.ftp.FTPUploadWorkItemHandler;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class FTPUploadWorkItemHandlerTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Mock
    FTPClient client;
    @Mock
    Connection connection;

    @Test
    public void testFTPUpload() throws Exception {
        ((FTPClient)Mockito.doNothing().when((Object)this.client)).connect("abc", 123);
        Mockito.when((Object)this.client.getReplyCode()).thenReturn((Object)200);
        Mockito.when((Object)this.client.login(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.client.setFileType(Mockito.anyInt())).thenReturn((Object)true);
        Mockito.when((Object)this.client.storeFile(Mockito.anyString(), (InputStream)Mockito.anyObject())).thenReturn((Object)true);
        Mockito.when((Object)this.client.logout()).thenReturn((Object)true);
        Mockito.when((Object)this.connection.getHost()).thenReturn((Object)"abc");
        Mockito.when((Object)this.connection.getPort()).thenReturn((Object)"123");
        File tempFile = this.tempFolder.newFile("tempFile1.txt");
        FileUtils.writeStringToFile((File)tempFile, (String)"temp file content", (String)"UTF-8");
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(123L);
        workItem.setParameter("File", (Object)tempFile);
        workItem.setParameter("User", (Object)"someuser");
        workItem.setParameter("Password", (Object)"somepassword");
        FTPUploadWorkItemHandler handler = new FTPUploadWorkItemHandler();
        handler.setLogThrownException(true);
        handler.setFTPClient(this.client);
        handler.setConnection(this.connection);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testFTPUploadInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(123L);
        FTPUploadWorkItemHandler handler = new FTPUploadWorkItemHandler();
        handler.setLogThrownException(true);
        handler.setFTPClient(this.client);
        handler.setConnection(this.connection);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

