/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.github;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.egit.github.core.service.IssueService;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.github.GithubAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GithubFetchIssues.wid", name="GithubFetchIssues", displayName="GithubFetchIssues", defaultHandler="mvel: new org.jbpm.process.workitem.github.FetchIssuesWorkitemHandler(\"userName\", \"password\")", documentation="github-workitem/index.html", category="github-workitem", icon="GithubFetchIssues.png", parameters={@WidParameter(name="User", required=true), @WidParameter(name="RepoName", required=true), @WidParameter(name="IssuesState")}, results={@WidResult(name="IssuesList", runtimeType="java.util.List")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="github-workitem", version="7.16.0.Final")}, serviceInfo=@WidService(category="Github", description="Create Gist or list your repositories in Github", keywords="github,repo,repository,fetch,issues", action=@WidAction(title="Fetch issues for a project from GitHub"), authinfo=@WidAuth(required=true, params={"userName", "password"}, paramsdescription={"Github username", "Github password"}, referencesite="https://github.com/")))
public class FetchIssuesWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private GithubAuth auth = new GithubAuth();
    private static final Logger logger = LoggerFactory.getLogger(FetchIssuesWorkitemHandler.class);
    private static final String RESULTS_VALUE = "IssuesList";

    public FetchIssuesWorkitemHandler(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            List issues;
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap<String, List> results = new HashMap<String, List>();
            String user = (String)workItem.getParameter("User");
            String repoName = (String)workItem.getParameter("RepoName");
            String issuesState = (String)workItem.getParameter("IssuesState");
            IssueService issueService = this.auth.getIssueService(this.userName, this.password);
            if (issuesState == null || !issuesState.equalsIgnoreCase("open") || !issuesState.equalsIgnoreCase("closed")) {
                issuesState = "open";
            }
            if ((issues = issueService.getIssues(user, repoName, Collections.singletonMap("state", issuesState.toLowerCase()))) == null) {
                throw new IllegalArgumentException("Could not retrieve valid issues");
            }
            results.put(RESULTS_VALUE, issues);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GithubAuth auth) {
        this.auth = auth;
    }
}

