/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.github;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.MergeStatus;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.github.GithubAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GithubMergePullRequest.wid", name="GithubMergePullRequest", displayName="GithubMergePullRequest", defaultHandler="mvel: new org.jbpm.process.workitem.github.MergePullRequestWorkitemHandler()", parameters={@WidParameter(name="RepoOwner"), @WidParameter(name="RepoName"), @WidParameter(name="PullRequestNum"), @WidParameter(name="CommitMessage")}, results={@WidResult(name="IsMerged")}, mavenDepends={@WidMavenDepends(group="org.eclipse.mylyn.github", artifact="org.eclipse.egit.github.core", version="2.1.5")})
public class MergePullRequestWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private GithubAuth auth = new GithubAuth();
    private static final Logger logger = LoggerFactory.getLogger(MergePullRequestWorkitemHandler.class);
    private static final String RESULTS_VALUE = "IsMerged";

    public MergePullRequestWorkitemHandler(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            HashMap<String, Boolean> results = new HashMap<String, Boolean>();
            String repoOwner = (String)workItem.getParameter("RepoOwner");
            String repoName = (String)workItem.getParameter("RepoName");
            String pullRequestNum = (String)workItem.getParameter("PullRequestNum");
            String commitMessage = (String)workItem.getParameter("CommitMessage");
            if (StringUtils.isNotEmpty((CharSequence)repoOwner) && StringUtils.isNotEmpty((CharSequence)repoName) && StringUtils.isNumeric((CharSequence)pullRequestNum)) {
                RepositoryId repositoryId;
                PullRequestService pullRequestService = this.auth.getPullRequestService(this.userName, this.password);
                if (pullRequestService.getPullRequest((IRepositoryIdProvider)(repositoryId = new RepositoryId(repoOwner, repoName)), Integer.parseInt(pullRequestNum)).isMergeable()) {
                    MergeStatus mergeStatus = pullRequestService.merge((IRepositoryIdProvider)repositoryId, Integer.parseInt(pullRequestNum), commitMessage);
                    results.put(RESULTS_VALUE, mergeStatus.isMerged());
                } else {
                    results.put(RESULTS_VALUE, false);
                }
            } else {
                logger.error("Missing repository and pull request info.");
                throw new IllegalArgumentException("Missing repository and pull request info.");
            }
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GithubAuth auth) {
        this.auth = auth;
    }
}

