/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.github;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.eclipse.egit.github.core.Gist;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.MergeStatus;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.service.GistService;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.github.CreateGistWorkitemHandler;
import org.jbpm.process.workitem.github.FetchIssuesWorkitemHandler;
import org.jbpm.process.workitem.github.ForkRepositoryWorkitemHandler;
import org.jbpm.process.workitem.github.GithubAuth;
import org.jbpm.process.workitem.github.ListRepositoriesWorkitemHandler;
import org.jbpm.process.workitem.github.MergePullRequestWorkitemHandler;
import org.jbpm.process.workitem.github.RepositoryInfo;
import org.jbpm.test.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class GithubWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    GithubAuth auth;
    @Mock
    RepositoryService repositoryService;
    @Mock
    GistService gistService;
    @Mock
    PullRequestService pullRequestService;
    @Mock
    IssueService issueService;
    @Mock
    Gist gist;
    @Mock
    Repository forkedRepository;
    @Mock
    PullRequest pullRequest;
    @Mock
    MergeStatus mergeStatus;

    @Before
    public void setUp() {
        try {
            Mockito.when((Object)this.auth.getGistService(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.gistService);
            Mockito.when((Object)this.auth.getRespositoryService(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.repositoryService);
            Mockito.when((Object)this.auth.getPullRequestService(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.pullRequestService);
            Mockito.when((Object)this.auth.getIssueService(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.issueService);
            Mockito.when((Object)this.gistService.createGist((Gist)Mockito.any(Gist.class))).thenReturn((Object)this.gist);
            Mockito.when((Object)this.gist.getHtmlUrl()).thenReturn((Object)"testGistURL");
            Mockito.when((Object)this.repositoryService.forkRepository((IRepositoryIdProvider)Mockito.any(RepositoryId.class), Matchers.anyString())).thenReturn((Object)this.forkedRepository);
            ArrayList testRepoList = new ArrayList();
            Mockito.when((Object)this.repositoryService.getRepositories(Matchers.anyString())).thenReturn(testRepoList);
            Mockito.when((Object)this.pullRequestService.getPullRequest((IRepositoryIdProvider)Mockito.any(RepositoryId.class), Mockito.anyInt())).thenReturn((Object)this.pullRequest);
            Mockito.when((Object)this.pullRequest.isMergeable()).thenReturn((Object)true);
            Mockito.when((Object)this.pullRequestService.merge((IRepositoryIdProvider)Mockito.any(RepositoryId.class), Mockito.anyInt(), Matchers.anyString())).thenReturn((Object)this.mergeStatus);
            Mockito.when((Object)this.mergeStatus.isMerged()).thenReturn((Object)true);
            ArrayList<Issue> issueList = new ArrayList<Issue>();
            Issue issue1 = new Issue();
            issue1.setId(1L);
            issue1.setBody("issue1");
            Issue issue2 = new Issue();
            issue2.setId(2L);
            issue2.setBody("issue2");
            issueList.add(issue1);
            issueList.add(issue2);
            Mockito.when((Object)this.issueService.getIssues(Matchers.anyString(), Matchers.anyString(), (Map)Mockito.any(Map.class))).thenReturn(issueList);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateGist() throws Exception {
        DocumentImpl testGistDoc = new DocumentImpl();
        testGistDoc.setContent(new String("Test gist file content").getBytes());
        testGistDoc.setName("testGistFile.txt");
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Content", (Object)testGistDoc);
        workItem.setParameter("Description", (Object)"test gist");
        workItem.setParameter("IsPublic", (Object)"true");
        CreateGistWorkitemHandler handler = new CreateGistWorkitemHandler("testusername", "testpassword");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("GistURL") instanceof String));
        String createdGistURL = (String)((Map)manager.getResults().get(workItem.getId())).get("GistURL");
        Assert.assertNotNull((Object)createdGistURL);
        Assert.assertEquals((Object)"testGistURL", (Object)createdGistURL);
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testCreateGistInvalidParams() throws Exception {
        DocumentImpl testGistDoc = new DocumentImpl();
        testGistDoc.setContent(new String("Test gist file content").getBytes());
        testGistDoc.setName("testGistFile.txt");
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        CreateGistWorkitemHandler handler = new CreateGistWorkitemHandler("testusername", "testpassword");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }

    @Test
    public void testForkRepository() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("RepoOwner", (Object)"testRepoOwner");
        workItem.setParameter("RepoName", (Object)"testRepoName");
        workItem.setParameter("Organization", (Object)"testOrganization");
        ForkRepositoryWorkitemHandler handler = new ForkRepositoryWorkitemHandler("testusername", "testpassword");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("ForkedRepoInfo") instanceof RepositoryInfo));
    }

    @Test
    public void testListRepositories() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("User", (Object)"testUser");
        ListRepositoriesWorkitemHandler handler = new ListRepositoriesWorkitemHandler("testusername", "testpassword");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("RepoListInfo") instanceof List));
    }

    @Test
    public void testMergePullRequest() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("RepoOwner", (Object)"testRepoOwner");
        workItem.setParameter("RepoName", (Object)"testRepoName");
        workItem.setParameter("PullRequestNum", (Object)"10");
        workItem.setParameter("CommitMessage", (Object)"testCommitMessage");
        MergePullRequestWorkitemHandler handler = new MergePullRequestWorkitemHandler("testusername", "testpassword");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("IsMerged") instanceof Boolean));
        Boolean isPullRequestMerged = (Boolean)((Map)manager.getResults().get(workItem.getId())).get("IsMerged");
        Assert.assertNotNull((Object)isPullRequestMerged);
        Assert.assertTrue((boolean)isPullRequestMerged);
    }

    @Test
    public void testFetchIssues() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("User", (Object)"testUser");
        workItem.setParameter("RepoName", (Object)"testRepoName");
        workItem.setParameter("IssuesState", (Object)"open");
        FetchIssuesWorkitemHandler handler = new FetchIssuesWorkitemHandler("testusername", "testpassword");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("IssuesList") instanceof List));
        List issueList = (List)((Map)manager.getResults().get(workItem.getId())).get("IssuesList");
        Assert.assertNotNull((Object)issueList);
        Assert.assertEquals((long)2L, (long)issueList.size());
    }
}

