/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.github;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.github.GithubAuth;
import org.jbpm.process.workitem.github.RepositoryInfo;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GithubListRepositories.wid", name="GithubListRepositories", displayName="GithubListRepositories", defaultHandler="mvel: new org.jbpm.process.workitem.github.ListRepositoriesWorkitemHandler()", parameters={@WidParameter(name="User")}, results={@WidResult(name="RepoListInfo")}, mavenDepends={@WidMavenDepends(group="org.eclipse.mylyn.github", artifact="org.eclipse.egit.github.core", version="2.1.5")})
public class ListRepositoriesWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private GithubAuth auth = new GithubAuth();
    private static final Logger logger = LoggerFactory.getLogger(ListRepositoriesWorkitemHandler.class);
    private static final String RESULTS_VALUE = "RepoListInfo";

    public ListRepositoriesWorkitemHandler(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            ArrayList<RepositoryInfo> resultRepositoryInformation;
            HashMap results = new HashMap();
            String user = (String)workItem.getParameter("User");
            if (user != null) {
                RepositoryService repoService = this.auth.getRespositoryService(this.userName, this.password);
                List userRepos = repoService.getRepositories(user);
                resultRepositoryInformation = new ArrayList<RepositoryInfo>();
                if (userRepos != null) {
                    for (Repository repo : userRepos) {
                        resultRepositoryInformation.add(new RepositoryInfo(repo));
                    }
                } else {
                    logger.info("No repositories found for " + user);
                }
            } else {
                logger.error("Missing user name.");
                throw new IllegalArgumentException("Missing user name.");
            }
            results.put(RESULTS_VALUE, resultRepositoryInformation);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GithubAuth auth) {
        this.auth = auth;
    }
}

