/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.sheets;

import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.google.sheets.GoogleSheetsAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GoogleReadSheetValuesDefinitions.wid", name="GoogleReadSheetValues", displayName="GoogleReadSheetValues", defaultHandler="mvel: new org.jbpm.process.workitem.google.sheets.ReadSheetValuesWorkitemHandler()", parameters={@WidParameter(name="SheetId"), @WidParameter(name="Range")}, results={@WidResult(name="SheetValues")}, mavenDepends={@WidMavenDepends(group="com.google.apis", artifact="google-api-services-sheets", version="v4-rev488-1.23.0"), @WidMavenDepends(group="com.google.oauth-client", artifact="google-oauth-client-jetty", version="1.23.0"), @WidMavenDepends(group="com.google.api-client", artifact="google-api-client", version="1.23.0")})
public class ReadSheetValuesWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReadSheetValuesWorkitemHandler.class);
    private static final String RESULTS_VALUES = "SheetValues";
    private GoogleSheetsAuth auth = new GoogleSheetsAuth();
    private String appName;
    private String clientSecret;

    public ReadSheetValuesWorkitemHandler(String appName, String clientSecret) {
        this.appName = appName;
        this.clientSecret = clientSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap<String, List> results = new HashMap<String, List>();
        String paramSheetId = (String)workItem.getParameter("SheetId");
        String paramRange = (String)workItem.getParameter("Range");
        try {
            Sheets service = this.auth.getSheetsService(this.appName, this.clientSecret);
            ValueRange sheetResponse = (ValueRange)service.spreadsheets().values().get(paramSheetId, paramRange).execute();
            List values = sheetResponse.getValues();
            results.put(RESULTS_VALUES, values);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        workItemManager.completeWorkItem(workItem.getId(), results);
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GoogleSheetsAuth auth) {
        this.auth = auth;
    }
}

