/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.sheets;

import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.google.sheets.GoogleSheetsAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GoogleReadSheetValuesDefinitions.wid", name="GoogleReadSheetValues", displayName="GoogleReadSheetValues", defaultHandler="mvel: new org.jbpm.process.workitem.google.sheets.ReadSheetValuesWorkitemHandler(\"appName\", \"clentSecret\")", documentation="google-sheets-workitem/index.html", category="google-sheets-workitem", icon="GoogleReadSheetValues.png", parameters={@WidParameter(name="SheetId", required=true), @WidParameter(name="Range", required=true)}, results={@WidResult(name="SheetValues", runtimeType="java.util.List")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-sheets-workitem", version="7.66.0.Final")}, serviceInfo=@WidService(category="Google Sheets", description="Read content of sheets via Google", keywords="google,sheets,read", action=@WidAction(title="Read spreadsheet using Google Sheets"), authinfo=@WidAuth(required=true, params={"appName", "clentSecret"}, paramsdescription={"Google app name", "Google client secret"}, referencesite="https://developers.google.com/sheets/api/guides/authorizing")))
public class ReadSheetValuesWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReadSheetValuesWorkitemHandler.class);
    private static final String RESULTS_VALUES = "SheetValues";
    private GoogleSheetsAuth auth = new GoogleSheetsAuth();
    private String appName;
    private String clientSecret;

    public ReadSheetValuesWorkitemHandler(String appName, String clientSecret) {
        this.appName = appName;
        this.clientSecret = clientSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap<String, List> results = new HashMap<String, List>();
        String paramSheetId = (String)workItem.getParameter("SheetId");
        String paramRange = (String)workItem.getParameter("Range");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            Sheets service = this.auth.getSheetsService(this.appName, this.clientSecret);
            ValueRange sheetResponse = (ValueRange)service.spreadsheets().values().get(paramSheetId, paramRange).execute();
            List values = sheetResponse.getValues();
            results.put(RESULTS_VALUES, values);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GoogleSheetsAuth auth) {
        this.auth = auth;
    }
}

