/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.tasks;

import com.google.api.client.util.DateTime;
import com.google.api.services.tasks.Tasks;
import com.google.api.services.tasks.model.TaskList;
import java.util.Date;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.google.tasks.GoogleTasksAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GoogleAddTaskDefinitions.wid", name="GoogleAddTask", displayName="GoogleAddTask", defaultHandler="mvel: new org.jbpm.process.workitem.google.tasks.AddTaskWorkitemHandler(\"appName\", \"clentSecret\")", documentation="google-tasks-workitem/index.html", category="google-tasks-workitem", icon="GoogleAddTask.png", parameters={@WidParameter(name="TaskName", required=true), @WidParameter(name="TaskKind")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-tasks-workitem", version="7.38.0.Final")}, serviceInfo=@WidService(category="Google Tasks", description="Add and retrieve tasks via Google", keywords="google,tasks,add", action=@WidAction(title="Add a new task using Google Tasks"), authinfo=@WidAuth(required=true, params={"appName", "clentSecret"}, paramsdescription={"Google app name", "Google client secret"}, referencesite="https://developers.google.com/tasks/auth")))
public class AddTaskWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AddTaskWorkitemHandler.class);
    private GoogleTasksAuth auth = new GoogleTasksAuth();
    private String appName;
    private String clientSecret;

    public AddTaskWorkitemHandler(String appName, String clientSecret) {
        this.appName = appName;
        this.clientSecret = clientSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        String taskName = (String)workItem.getParameter("TaskName");
        String taskKind = (String)workItem.getParameter("TaskKind");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            Tasks service = this.auth.getTasksService(this.appName, this.clientSecret);
            TaskList taskList = new TaskList();
            taskList.setTitle(taskName);
            taskList.setId(taskName);
            taskList.setKind(taskKind);
            taskList.setUpdated(new DateTime(new Date()));
            service.tasklists().insert(taskList).execute();
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GoogleTasksAuth auth) {
        this.auth = auth;
    }
}

