/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.tasks;

import com.google.api.services.tasks.Tasks;
import com.google.api.services.tasks.model.TaskList;
import com.google.api.services.tasks.model.TaskLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.google.tasks.GoogleTasksAuth;
import org.jbpm.process.workitem.google.tasks.TaskInfo;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GoogleGetTasksDefinitions.wid", name="GoogleGetTasks", displayName="GoogleGetTasks", defaultHandler="mvel: new org.jbpm.process.workitem.google.tasks.GetTasksWorkitemHandler(\"appName\", \"clentSecret\")", documentation="google-tasks-workitem/index.html", category="google-tasks-workitem", icon="GoogleGetTasks.png", parameters={@WidParameter(name="NumOfTasks", required=true)}, results={@WidResult(name="FoundTasks", runtimeType="java.util.List")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-tasks-workitem", version="7.43.1.Final")}, serviceInfo=@WidService(category="Google Tasks", description="Add and retrieve tasks via Google", keywords="google,tasks,get", action=@WidAction(title="Get an existing task using Google Tasks"), authinfo=@WidAuth(required=true, params={"appName", "clentSecret"}, paramsdescription={"Google app name", "Google client secret"}, referencesite="https://developers.google.com/tasks/auth")))
public class GetTasksWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetTasksWorkitemHandler.class);
    private static final String RESULTS_VALUES = "FoundTasks";
    private GoogleTasksAuth auth = new GoogleTasksAuth();
    private String appName;
    private String clientSecret;

    public GetTasksWorkitemHandler(String appName, String clientSecret) {
        this.appName = appName;
        this.clientSecret = clientSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap results = new HashMap();
            Long numOfTasksLong = Long.valueOf((String)workItem.getParameter("NumOfTasks"));
            ArrayList<TaskInfo> tasksResultsList = new ArrayList<TaskInfo>();
            if (numOfTasksLong <= 0L) {
                logger.error("Number of tasks requested must be greater than zero.");
                throw new IllegalArgumentException("Number of tasks requested must be greater than zero.");
            }
            Tasks service = this.auth.getTasksService(this.appName, this.clientSecret);
            TaskLists result = (TaskLists)service.tasklists().list().setMaxResults(numOfTasksLong).execute();
            if (result == null) {
                logger.error("Invalid task list result.");
                throw new Exception("Invalid task list result.");
            }
            List tasklist = result.getItems();
            if (tasklist != null) {
                for (TaskList tl : tasklist) {
                    tasksResultsList.add(new TaskInfo(tl));
                }
            }
            results.put(RESULTS_VALUES, tasksResultsList);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GoogleTasksAuth auth) {
        this.auth = auth;
    }
}

