/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.tasks;

import com.google.api.client.util.DateTime;
import com.google.api.services.tasks.Tasks;
import com.google.api.services.tasks.model.TaskList;
import java.util.Date;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.google.tasks.GoogleTasksAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GoogleAddTaskDefinitions.wid", name="GoogleAddTask", displayName="GoogleAddTask", defaultHandler="mvel: new org.jbpm.process.workitem.google.tasks.AddTaskWorkitemHandler()", parameters={@WidParameter(name="TaskName"), @WidParameter(name="TaskKind")}, mavenDepends={@WidMavenDepends(group="com.google.apis", artifact="google-api-services-tasks", version="v1-rev48-1.23.0"), @WidMavenDepends(group="com.google.oauth-client", artifact="google-oauth-client-jetty", version="1.23.0"), @WidMavenDepends(group="com.google.api-client", artifact="google-api-client", version="1.23.0")})
public class AddTaskWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AddTaskWorkitemHandler.class);
    private GoogleTasksAuth auth = new GoogleTasksAuth();
    private String appName;
    private String clientSecret;

    public AddTaskWorkitemHandler(String appName, String clientSecret) {
        this.appName = appName;
        this.clientSecret = clientSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        String taskName = (String)workItem.getParameter("TaskName");
        String taskKind = (String)workItem.getParameter("TaskKind");
        if (taskName == null) {
            logger.error("Missing task name input.");
            throw new IllegalArgumentException("Missing task name input.");
        }
        try {
            Tasks service = this.auth.getTasksService(this.appName, this.clientSecret);
            TaskList taskList = new TaskList();
            taskList.setTitle(taskName);
            taskList.setId(taskName);
            taskList.setKind(taskKind);
            taskList.setUpdated(new DateTime(new Date()));
            service.tasklists().insert(taskList).execute();
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GoogleTasksAuth auth) {
        this.auth = auth;
    }
}

