/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.translate;

import com.google.cloud.translate.Detection;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.Translation;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.google.translate.DetectLanguageWorkitemHandler;
import org.jbpm.process.workitem.google.translate.GoogleTranslateAuth;
import org.jbpm.process.workitem.google.translate.TranslateWorkitemHandler;
import org.jbpm.test.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GoogleTranslateWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    GoogleTranslateAuth auth;
    @Mock
    Translate translationService;
    @Mock
    Detection detection;
    @Mock
    Translation translation;

    @Before
    public void setUp() {
        try {
            Mockito.when((Object)this.auth.getTranslationService(Matchers.anyString())).thenReturn((Object)this.translationService);
            Mockito.when((Object)this.translationService.detect(Matchers.anyString())).thenReturn((Object)this.detection);
            Mockito.when((Object)this.detection.getLanguage()).thenReturn((Object)"Serbian");
            Mockito.when((Object)this.translationService.translate(Matchers.anyString(), new Translate.TranslateOption[]{(Translate.TranslateOption)Mockito.any(Translate.TranslateOption.class), (Translate.TranslateOption)Mockito.any(Translate.TranslateOption.class)})).thenReturn((Object)this.translation);
            Mockito.when((Object)this.translation.getTranslatedText()).thenReturn((Object)"Dobar dan");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDetectLanguage() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ToDetectText", (Object)"Dobar dan");
        DetectLanguageWorkitemHandler handler = new DetectLanguageWorkitemHandler("testApiKey");
        handler.setTranslationAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        String detectedLanguage = (String)((Map)manager.getResults().get(workItem.getId())).get("DetectedLanguage");
        Assert.assertNotNull((Object)detectedLanguage);
        Assert.assertEquals((Object)"Serbian", (Object)detectedLanguage);
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testDetectLanguageInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        DetectLanguageWorkitemHandler handler = new DetectLanguageWorkitemHandler("testApiKey");
        handler.setTranslationAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }

    @Test
    public void testTranslateText() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ToTranslate", (Object)"Guten Tag");
        workItem.setParameter("SourceLang", (Object)"de");
        workItem.setParameter("TargetLang", (Object)"sr");
        TranslateWorkitemHandler handler = new TranslateWorkitemHandler("testApiKey");
        handler.setTranslationAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        String translation = (String)((Map)manager.getResults().get(workItem.getId())).get("Translation");
        Assert.assertNotNull((Object)translation);
        Assert.assertEquals((Object)"Dobar dan", (Object)translation);
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testTranslateTextInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        TranslateWorkitemHandler handler = new TranslateWorkitemHandler("testApiKey");
        handler.setTranslationAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

