/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ibm.watson;

import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.visual_recognition.v3.VisualRecognition;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassResult;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifiedImage;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifiedImages;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifierResult;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifyOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DetectFacesOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DetectedFaces;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.Face;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.FaceAge;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.FaceGender;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.FaceIdentity;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ImageWithFaces;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.ibm.watson.ClassifyImageWorkitemHandler;
import org.jbpm.process.workitem.ibm.watson.DetectFacesWorkitemHandler;
import org.jbpm.process.workitem.ibm.watson.WatsonAuth;
import org.jbpm.process.workitem.ibm.watson.result.FaceDetectionResult;
import org.jbpm.process.workitem.ibm.watson.result.ImageClassificationResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class WatsonWorkitemHandlerTest {
    @Mock
    WatsonAuth auth;
    @Mock
    VisualRecognition associationService;
    @Mock
    ServiceCall<ClassifiedImages> associationServiceCall;
    @Mock
    ClassifiedImages assoiationClassifiedImages;
    @Mock
    ClassifiedImage associationClassifiedImage;
    @Mock
    ClassifierResult associationClassifierResult;
    @Mock
    VisualRecognition recognitionService;
    @Mock
    ServiceCall<DetectedFaces> recognitionServiceCall;
    @Mock
    DetectedFaces recognitionDetectFaces;
    @Mock
    ImageWithFaces recognitionImageWithFaces;

    @Before
    public void setUp() {
        ClassResult classResultObj = new ClassResult();
        classResultObj.setClassName("testClassName");
        classResultObj.setScore(new Float(1.0f));
        classResultObj.setTypeHierarchy("testTypeHierarchy");
        ArrayList<ClassifiedImage> classifiedImageList = new ArrayList<ClassifiedImage>();
        classifiedImageList.add(this.associationClassifiedImage);
        ArrayList<ClassifierResult> classifierResults = new ArrayList<ClassifierResult>();
        classifierResults.add(this.associationClassifierResult);
        ArrayList<ClassResult> classResults = new ArrayList<ClassResult>();
        classResults.add(classResultObj);
        Mockito.when((Object)this.associationService.classify((ClassifyOptions)Mockito.any(ClassifyOptions.class))).thenReturn(this.associationServiceCall);
        Mockito.when((Object)this.associationServiceCall.execute()).thenReturn((Object)this.assoiationClassifiedImages);
        Mockito.when((Object)this.assoiationClassifiedImages.getImages()).thenReturn(classifiedImageList);
        Mockito.when((Object)this.associationClassifiedImage.getClassifiers()).thenReturn(classifierResults);
        Mockito.when((Object)this.associationClassifierResult.getClasses()).thenReturn(classResults);
        Mockito.when((Object)this.associationClassifierResult.getClassifierId()).thenReturn((Object)"testClassifierId");
        ArrayList<ImageWithFaces> recognitionImageList = new ArrayList<ImageWithFaces>();
        recognitionImageList.add(this.recognitionImageWithFaces);
        FaceAge recognitionFaceAge = new FaceAge();
        recognitionFaceAge.setMin(20L);
        recognitionFaceAge.setMax(35L);
        FaceGender recognitionFaceGender = new FaceGender();
        recognitionFaceGender.setGender("male");
        FaceIdentity recognitionFaceIdentity = new FaceIdentity();
        recognitionFaceIdentity.setName("testPerson");
        Face recognitionFace = new Face();
        recognitionFace.setAge(recognitionFaceAge);
        recognitionFace.setGender(recognitionFaceGender);
        recognitionFace.setIdentity(recognitionFaceIdentity);
        ArrayList<Face> recognitionFaceList = new ArrayList<Face>();
        recognitionFaceList.add(recognitionFace);
        Mockito.when((Object)this.recognitionService.detectFaces((DetectFacesOptions)Mockito.any(DetectFacesOptions.class))).thenReturn(this.recognitionServiceCall);
        Mockito.when((Object)this.recognitionServiceCall.execute()).thenReturn((Object)this.recognitionDetectFaces);
        Mockito.when((Object)this.recognitionDetectFaces.getImages()).thenReturn(recognitionImageList);
        Mockito.when((Object)this.recognitionImageWithFaces.getFaces()).thenReturn(recognitionFaceList);
        Mockito.when((Object)this.recognitionImageWithFaces.getImage()).thenReturn((Object)"testImage");
    }

    @Test
    public void testClassifyImage() throws Exception {
        Mockito.when((Object)this.auth.getService(Mockito.anyString())).thenReturn((Object)this.associationService);
        TestWorkItemManager manager = new TestWorkItemManager();
        DocumentImpl imageToClassify = new DocumentImpl();
        imageToClassify.setName("testImageToClassify.png");
        imageToClassify.setContent(new String("testImageContent").getBytes());
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ImageToClassify", (Object)imageToClassify);
        ClassifyImageWorkitemHandler handler = new ClassifyImageWorkitemHandler("{testApiKey}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("Classification") instanceof List));
        List returnValues = (List)((Map)manager.getResults().get(workItem.getId())).get("Classification");
        Assert.assertNotNull((Object)returnValues);
        Assert.assertEquals((long)1L, (long)returnValues.size());
        ImageClassificationResult result = (ImageClassificationResult)returnValues.get(0);
        Assert.assertTrue((result.getClassScore().floatValue() == 1.0f ? 1 : 0) != 0);
        Assert.assertEquals((Object)"testClassName", (Object)result.getClassName());
        Assert.assertEquals((Object)"testTypeHierarchy", (Object)result.getClassTypeHierarchy());
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testClassifyImageInvalidParams() throws Exception {
        Mockito.when((Object)this.auth.getService(Mockito.anyString())).thenReturn((Object)this.associationService);
        TestWorkItemManager manager = new TestWorkItemManager();
        DocumentImpl imageToClassify = new DocumentImpl();
        imageToClassify.setName("testImageToClassify.png");
        imageToClassify.setContent(new String("testImageContent").getBytes());
        WorkItemImpl workItem = new WorkItemImpl();
        ClassifyImageWorkitemHandler handler = new ClassifyImageWorkitemHandler("{testApiKey}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }

    @Test
    public void testDetectFaces() throws Exception {
        Mockito.when((Object)this.auth.getService(Mockito.anyString())).thenReturn((Object)this.recognitionService);
        TestWorkItemManager manager = new TestWorkItemManager();
        DocumentImpl imagetoDetect = new DocumentImpl();
        imagetoDetect.setName("testImageToDetect.png");
        imagetoDetect.setContent(new String("testImageContent").getBytes());
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ImageToDetect", (Object)imagetoDetect);
        DetectFacesWorkitemHandler handler = new DetectFacesWorkitemHandler("{testApiKey}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("Detection") instanceof List));
        List returnValues = (List)((Map)manager.getResults().get(workItem.getId())).get("Detection");
        Assert.assertNotNull((Object)returnValues);
        Assert.assertEquals((long)1L, (long)returnValues.size());
        FaceDetectionResult result = (FaceDetectionResult)returnValues.get(0);
        Assert.assertTrue((result.getMinAge() == 20L ? 1 : 0) != 0);
        Assert.assertTrue((result.getMaxAge() == 35L ? 1 : 0) != 0);
        Assert.assertEquals((Object)"male", (Object)result.getGender());
        Assert.assertEquals((Object)"testPerson", (Object)result.getIdentity());
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testDetectFacesInvalidParams() throws Exception {
        Mockito.when((Object)this.auth.getService(Mockito.anyString())).thenReturn((Object)this.recognitionService);
        TestWorkItemManager manager = new TestWorkItemManager();
        DocumentImpl imagetoDetect = new DocumentImpl();
        imagetoDetect.setName("testImageToDetect.png");
        imagetoDetect.setContent(new String("testImageContent").getBytes());
        WorkItemImpl workItem = new WorkItemImpl();
        DetectFacesWorkitemHandler handler = new DetectFacesWorkitemHandler("{testApiKey}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

