/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ibm.watson;

import com.ibm.watson.developer_cloud.visual_recognition.v3.VisualRecognition;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DetectFacesOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DetectedFaces;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.Face;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ImageWithFaces;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.document.Document;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.ibm.watson.WatsonAuth;
import org.jbpm.process.workitem.ibm.watson.result.FaceDetectionResult;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="DetectFacesDefinitions.wid", name="IBMWatsonDetectFaces", displayName="IBMWatsonDetectFaces", defaultHandler="mvel: new org.jbpm.process.workitem.ibm.watson.DetectFacesWorkitemHandler(\"apiKey\")", documentation="ibm-watson-workitem/index.html", category="ibm-watson-workitem", icon="IBMWatsonDetectFaces.png", parameters={@WidParameter(name="ImageToDetect", required=true, runtimeType="org.jbpm.document.Document")}, results={@WidResult(name="Detection", runtimeType="java.util.List")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="ibm-watson-workitem", version="7.59.0.Final")}, serviceInfo=@WidService(category="IBM Watson", description="Classify image and detect faces in image via IBM Watson", keywords="ibm,watson,image,detect,face,faces", action=@WidAction(title="Detect faces in an image using IBM Watson"), authinfo=@WidAuth(required=true, params={"apiKey"}, paramsdescription={"IBM Watson api key"}, referencesite="https://www.ibm.com/watson/developercloud/doc/virtual-agent/api-keys.html")))
public class DetectFacesWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(DetectFacesWorkitemHandler.class);
    private static final String RESULT_VALUE = "Detection";
    private WatsonAuth auth = new WatsonAuth();
    private String apiKey;

    public DetectFacesWorkitemHandler(String apiKey) {
        this.apiKey = apiKey;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            Document detectionImage = (Document)workItem.getParameter("ImageToDetect");
            HashMap widResults = new HashMap();
            VisualRecognition service = this.auth.getService(this.apiKey);
            ByteArrayInputStream imageStream = new ByteArrayInputStream(detectionImage.getContent());
            DetectFacesOptions detectFacesOptions = new DetectFacesOptions.Builder().imagesFile((InputStream)imageStream).build();
            DetectedFaces result = (DetectedFaces)service.detectFaces(detectFacesOptions).execute();
            if (result == null || result.getImages() == null || result.getImages().size() < 1) {
                logger.error("Unable to detect faces on provided image.");
                workItemManager.abortWorkItem(workItem.getId());
            } else {
                ArrayList<FaceDetectionResult> resultList = new ArrayList<FaceDetectionResult>();
                for (ImageWithFaces imageWithFaces : result.getImages()) {
                    for (Face face : imageWithFaces.getFaces()) {
                        resultList.add(new FaceDetectionResult(imageWithFaces, face));
                    }
                }
                widResults.put(RESULT_VALUE, resultList);
                workItemManager.completeWorkItem(workItem.getId(), widResults);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(WatsonAuth auth) {
        this.auth = auth;
    }
}

