/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ifttt;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.ifttt.IFTTTWorkitemHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class IFTTTWorkitemHandlerTest {
    @Mock
    Client client;
    @Mock
    WebTarget webTarget;
    @Mock
    Invocation.Builder builder;

    @Before
    public void setUp() {
        Mockito.when((Object)this.client.target(Mockito.anyString())).thenReturn((Object)this.webTarget);
        Mockito.when((Object)this.webTarget.request()).thenReturn((Object)this.builder);
        Mockito.when((Object)this.builder.post((Entity)Mockito.any(Entity.class), (Class)Mockito.any(Class.class))).thenReturn((Object)new String("testResponse"));
    }

    @Test
    public void testSendTriggerRequest() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Trigger", (Object)"testTrigger");
        workItem.setParameter("Value1", (Object)"testValue1");
        workItem.setParameter("Value2", (Object)"testValue2");
        workItem.setParameter("Value3", (Object)"testValue3");
        IFTTTWorkitemHandler handler = new IFTTTWorkitemHandler("testKey");
        handler.setClient(this.client);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        String testValueJSONString = "{\"value1\":\"testValue1\",\"value2\":\"testValue1\",\"value3\":\"testValue1\"}";
        Assert.assertEquals((Object)testValueJSONString, (Object)handler.getRequestBody());
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testSendTriggerRequestInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        IFTTTWorkitemHandler handler = new IFTTTWorkitemHandler("testKey");
        handler.setClient(this.client);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

