/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jabber;

import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.jabber.JabberWorkItemHandler;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class JabberWorkItemHandlerTest {
    @Mock
    ConnectionConfiguration connectionConf;
    @Mock
    XMPPConnection xmppConnection;
    @Mock
    ChatManager chatManager;
    @Mock
    Chat chat;

    @Test
    public void testSendMessage() throws Exception {
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ((XMPPConnection)Mockito.doNothing().when((Object)this.xmppConnection)).connect();
        ((XMPPConnection)Mockito.doNothing().when((Object)this.xmppConnection)).login(Mockito.anyString(), Mockito.anyString());
        ((XMPPConnection)Mockito.doNothing().when((Object)this.xmppConnection)).sendPacket((Packet)Mockito.any(Presence.class));
        ((XMPPConnection)Mockito.doNothing().when((Object)this.xmppConnection)).disconnect();
        Mockito.when((Object)this.xmppConnection.getChatManager()).thenReturn((Object)this.chatManager);
        Mockito.when((Object)this.chatManager.createChat(Mockito.anyString(), (MessageListener)Mockito.anyObject())).thenReturn((Object)this.chat);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("User", (Object)"myuser");
        workItem.setParameter("Password", (Object)"mypassword");
        workItem.setParameter("Server", (Object)"myserver");
        workItem.setParameter("Port", (Object)"123");
        workItem.setParameter("Service", (Object)"myservice");
        workItem.setParameter("Text", (Object)"hello world");
        workItem.setParameter("To", (Object)"someperson");
        JabberWorkItemHandler handler = new JabberWorkItemHandler();
        handler.setConf(this.connectionConf);
        handler.setConnection(this.xmppConnection);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        ((Chat)Mockito.verify((Object)this.chat)).sendMessage((Message)messageCaptor.capture());
        Assert.assertEquals((Object)"hello world", (Object)((Message)messageCaptor.getValue()).getBody());
    }
}

