/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.handler;

import java.util.Map;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.handler.JavaHandler;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

@Wid(widfile="JavaDefinitions.wid", name="Java", displayName="Java", defaultHandler="mvel: new org.jbpm.process.workitem.java.JavaHandlerWorkItemHandler(\"ksession\")", documentation="java-workitem/index.html", category="java-workitem", icon="Java.png", parameters={@WidParameter(name="Class", required=true)}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="java-workitem", version="7.41.0.Final")}, serviceInfo=@WidService(category="Java", description="Execute Java class", keywords="java,handler,class,execute", action=@WidAction(title="Execute an existing Java Workitem Handler"), authinfo=@WidAuth))
public class JavaHandlerWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private KieSession ksession;

    public JavaHandlerWorkItemHandler() {
    }

    public JavaHandlerWorkItemHandler(KieSession ksession) {
        this.ksession = ksession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String className = (String)workItem.getParameter("Class");
            Class<?> c = Class.forName(className);
            JavaHandler handler = (JavaHandler)c.newInstance();
            KieSession localksession = this.ksession;
            RuntimeManager runtimeManager = null;
            RuntimeEngine engine = null;
            if (localksession == null) {
                runtimeManager = RuntimeManagerRegistry.get().getManager(((org.drools.core.process.instance.WorkItem)workItem).getDeploymentId());
                engine = runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)workItem.getProcessInstanceId()));
                localksession = engine.getKieSession();
            }
            org.drools.core.spi.ProcessContext kcontext = new org.drools.core.spi.ProcessContext((KieRuntime)localksession);
            try {
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)localksession.getProcessInstance(workItem.getProcessInstanceId());
                kcontext.setProcessInstance((ProcessInstance)processInstance);
                WorkItemNodeInstance nodeInstance = this.findNodeInstance(workItem.getId(), (NodeInstanceContainer)processInstance);
                kcontext.setNodeInstance((NodeInstance)nodeInstance);
                Map<String, Object> results = handler.execute((ProcessContext)kcontext);
                manager.completeWorkItem(workItem.getId(), results);
            }
            finally {
                if (engine != null) {
                    runtimeManager.disposeRuntimeEngine(engine);
                }
            }
            return;
        }
        catch (Exception e) {
            this.handleException(e);
            return;
        }
    }

    public void abortWorkItem(WorkItem arg0, WorkItemManager arg1) {
    }
}

