/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.springboot.samples;

import java.util.Collection;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.runtime.query.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class JBPMApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(JBPMApplication.class);

    public static void main(String[] args) {
        SpringApplication.run(JBPMApplication.class, (String[])args);
    }

    @Bean
    CommandLineRunner deployAndValidate() {
        return new CommandLineRunner(){
            @Autowired
            private DeploymentService deploymentService;
            @Autowired
            private RuntimeDataService runtimeDataService;
            @Autowired
            private ProcessService processService;

            public void run(String ... strings) throws Exception {
                KModuleDeploymentUnit unit = null;
                if (strings.length > 0) {
                    String arg = strings[0];
                    LOGGER.info("About to deploy : {}", (Object)arg);
                    String[] gav = arg.split(":");
                    unit = new KModuleDeploymentUnit((String)gav[0], (String)gav[1], (String)gav[2]);
                    this.deploymentService.deploy((DeploymentUnit)unit);
                    LOGGER.info("{} successfully deployed", (Object)arg);
                }
                LOGGER.info("Available processes:");
                Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
                for (ProcessDefinition def : processes) {
                    LOGGER.info("\t{} (with id '{})", (Object)def.getName(), (Object)def.getId());
                }
                if (unit != null && !processes.isEmpty()) {
                    String processId = ((ProcessDefinition)processes.iterator().next()).getId();
                    LOGGER.info("About to start process with id {}", (Object)processId);
                    long processInstanceId = this.processService.startProcess(unit.getIdentifier(), processId);
                    LOGGER.info("Started instance of {} process with id {}", (Object)processId, (Object)processInstanceId);
                    this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
                    LOGGER.info("Aborted instance with id {}", (Object)processInstanceId);
                }
                LOGGER.info("========= Verification completed successfully =========");
            }
        };
    }
}

