/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jira;

import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.MetadataRestClient;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.ProjectRestClient;
import com.atlassian.jira.rest.client.SearchRestClient;
import com.atlassian.jira.rest.client.UserRestClient;
import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.IssueType;
import com.atlassian.jira.rest.client.domain.SearchResult;
import com.atlassian.jira.rest.client.domain.Transition;
import com.atlassian.jira.rest.client.domain.User;
import com.atlassian.jira.rest.client.domain.input.IssueInput;
import com.atlassian.jira.rest.client.domain.input.TransitionInput;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.jira.AddCommentOnIssueWorkitemHandler;
import org.jbpm.process.workitem.jira.CreateIssueWorkitemHandler;
import org.jbpm.process.workitem.jira.JiraAuth;
import org.jbpm.process.workitem.jira.JqlSearchWorkitemHandler;
import org.jbpm.process.workitem.jira.ResolveIssueWorkitemHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class JiraWorkitemHandlerTest {
    @Mock
    JiraAuth auth;
    @Mock
    IssueRestClient issueRestClient;
    @Mock
    JiraRestClient jiraRestClient;
    @Mock
    MetadataRestClient metadataRestClient;
    @Mock
    ProjectRestClient projectRestClient;
    @Mock
    SearchRestClient searchRestClient;
    @Mock
    UserRestClient userRestClient;
    @Mock
    SearchResult searchResults;
    @Mock
    User user;
    private URI testURI = URI.create("http://testURI.com/test");

    @Before
    public void setUp() {
        try {
            Mockito.when((Object)this.auth.getIssueRestClient()).thenReturn((Object)this.issueRestClient);
            Mockito.when((Object)this.auth.getMetaDataRestClient()).thenReturn((Object)this.metadataRestClient);
            Mockito.when((Object)this.auth.getProjectRestClient()).thenReturn((Object)this.projectRestClient);
            Mockito.when((Object)this.auth.getSearchRestClient()).thenReturn((Object)this.searchRestClient);
            Mockito.when((Object)this.auth.getUserRestClient()).thenReturn((Object)this.userRestClient);
            IssueType testIssueType = new IssueType(this.testURI, Long.valueOf(1L), "testIssueType", false, "test descriptoin", this.testURI);
            ArrayList<IssueType> testIssueTypes = new ArrayList<IssueType>();
            testIssueTypes.add(testIssueType);
            Mockito.when((Object)this.metadataRestClient.getIssueTypes((ProgressMonitor)Mockito.any(ProgressMonitor.class))).thenReturn(testIssueTypes);
            BasicIssue basicIssue = new BasicIssue(this.testURI, "testIssueKey");
            Mockito.when((Object)this.issueRestClient.createIssue((IssueInput)Mockito.any(IssueInput.class), (ProgressMonitor)Mockito.any(ProgressMonitor.class))).thenReturn((Object)basicIssue);
            Issue issue = new Issue("", null, "testIssueKey", null, null, null, "", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
            Mockito.when((Object)this.issueRestClient.getIssue(Matchers.anyString(), (ProgressMonitor)Mockito.any(ProgressMonitor.class))).thenReturn((Object)issue);
            ((IssueRestClient)Mockito.doNothing().when((Object)this.issueRestClient)).addComment((ProgressMonitor)Mockito.any(ProgressMonitor.class), (URI)Mockito.any(URI.class), (Comment)Mockito.any(Comment.class));
            Transition testTransition = new Transition("Resolve Issue", 1, null);
            ArrayList<Transition> testAllTransitions = new ArrayList<Transition>();
            testAllTransitions.add(testTransition);
            Mockito.when((Object)this.issueRestClient.getTransitions((URI)Mockito.any(URI.class), (ProgressMonitor)Mockito.any(ProgressMonitor.class))).thenReturn(testAllTransitions);
            ((IssueRestClient)Mockito.doNothing().when((Object)this.issueRestClient)).transition((URI)Mockito.any(URI.class), (TransitionInput)Mockito.any(TransitionInput.class), (ProgressMonitor)Mockito.any(ProgressMonitor.class));
            ArrayList<BasicIssue> testSearchResults = new ArrayList<BasicIssue>();
            testSearchResults.add(basicIssue);
            Mockito.when((Object)this.searchRestClient.searchJql(Matchers.anyString(), (ProgressMonitor)Mockito.any(ProgressMonitor.class))).thenReturn((Object)this.searchResults);
            Mockito.when((Object)this.searchResults.getIssues()).thenReturn(testSearchResults);
            Mockito.when((Object)this.userRestClient.getUser(Matchers.anyString(), (ProgressMonitor)Mockito.any(ProgressMonitor.class))).thenReturn((Object)this.user);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateIssue() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ProjectKey", (Object)"testJiraProject");
        workItem.setParameter("IssueSummary", (Object)"test issue summary");
        workItem.setParameter("IssueDescription", (Object)"this is test issue description");
        workItem.setParameter("IssueType", (Object)"testIssueType");
        workItem.setParameter("AssigneeName", (Object)"testAssigneeName");
        workItem.setParameter("ReporterName", (Object)"testReporterName");
        workItem.setParameter("ComponentName", (Object)"testComponentName");
        CreateIssueWorkitemHandler handler = new CreateIssueWorkitemHandler("testusername", "testpassword", "testjiraurl");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("CreatedIssueKey") instanceof String));
        String cretedJiraKey = (String)((Map)manager.getResults().get(workItem.getId())).get("CreatedIssueKey");
        Assert.assertNotNull((Object)cretedJiraKey);
        Assert.assertEquals((Object)"testIssueKey", (Object)cretedJiraKey);
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testCreateIssueInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        CreateIssueWorkitemHandler handler = new CreateIssueWorkitemHandler("testusername", "testpassword", "testjiraurl");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }

    @Test
    public void testJqlSearch() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("SearchQuery", (Object)"test jql query");
        JqlSearchWorkitemHandler handler = new JqlSearchWorkitemHandler("testusername", "testpassword", "testjiraurl");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("SearchResults") instanceof Map));
        Map searchResults = (Map)((Map)manager.getResults().get(workItem.getId())).get("SearchResults");
        Assert.assertNotNull((Object)searchResults);
        Assert.assertEquals((long)1L, (long)searchResults.size());
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testJqlSearchInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        JqlSearchWorkitemHandler handler = new JqlSearchWorkitemHandler("testusername", "testpassword", "testjiraurl");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }

    @Test
    public void testAddComment() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("IssueKey", (Object)"testIssueKey");
        workItem.setParameter("Comment", (Object)"testComment");
        workItem.setParameter("Commenter", (Object)"testCommenter");
        workItem.setParameter("CommentVisibleTo", (Object)"testVisibilityGroup");
        AddCommentOnIssueWorkitemHandler handler = new AddCommentOnIssueWorkitemHandler("testusername", "testpassword", "testjiraurl");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testAddCommentInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        AddCommentOnIssueWorkitemHandler handler = new AddCommentOnIssueWorkitemHandler("testusername", "testpassword", "testjiraurl");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }

    @Test
    public void testResolveIssue() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("IssueKey", (Object)"testIssueKey");
        workItem.setParameter("Resolution", (Object)"testResolved");
        workItem.setParameter("ResolutionComment", (Object)"testResolutionComment");
        ResolveIssueWorkitemHandler handler = new ResolveIssueWorkitemHandler("testusername", "testpassword", "testjiraurl");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testResolveIssueInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        ResolveIssueWorkitemHandler handler = new ResolveIssueWorkitemHandler("testusername", "testpassword", "testjiraurl");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

