/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jira;

import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.User;
import com.atlassian.jira.rest.client.domain.Visibility;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.jira.JiraAuth;
import org.joda.time.DateTime;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="JiraAddComment.wid", name="JiraAddComment", displayName="JiraAddComment", defaultHandler="mvel: new org.jbpm.process.workitem.jira.AddCommentOnIssueWorkitemHandler()", documentation="jira-workitem/index.html", parameters={@WidParameter(name="IssueKey", required=true), @WidParameter(name="Comment", required=true), @WidParameter(name="Commenter"), @WidParameter(name="CommentVisibleTo")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="jira-workitem", version="7.14.0.Final")}, serviceInfo=@WidService(category="Jira", description="Create or update Jiras", keywords="jira,issue,add,comment", action=@WidAction(title="Add comment to an existing Jira issue")))
public class AddCommentOnIssueWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private String repoURI;
    private JiraAuth auth;
    private static final Logger logger = LoggerFactory.getLogger(AddCommentOnIssueWorkitemHandler.class);

    public AddCommentOnIssueWorkitemHandler(String userName, String password, String repoURI) {
        this.userName = userName;
        this.password = password;
        this.repoURI = repoURI;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String issueKey = (String)workItem.getParameter("IssueKey");
            String comment = (String)workItem.getParameter("Comment");
            String commenter = (String)workItem.getParameter("Commenter");
            String commentVisibleTo = (String)workItem.getParameter("CommentVisibleTo");
            if (this.auth == null) {
                this.auth = new JiraAuth(this.userName, this.password, this.repoURI);
            }
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            Issue issue = this.auth.getIssueRestClient().getIssue(issueKey, (ProgressMonitor)progressMonitor);
            User user = this.auth.getUserRestClient().getUser(commenter, (ProgressMonitor)progressMonitor);
            if (issue == null) {
                logger.error("Could not find issue with key: " + issueKey);
                throw new IllegalArgumentException("Could not find issue with key: " + issueKey);
            }
            Comment toAddComment = new Comment(null, comment, (BasicUser)user, null, new DateTime(), null, new Visibility(Visibility.Type.GROUP, commentVisibleTo), null);
            this.auth.getIssueRestClient().addComment((ProgressMonitor)progressMonitor, issue.getSelf(), toAddComment);
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            logger.error("Error executing workitem: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(JiraAuth auth) {
        this.auth = auth;
    }
}

