/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jira;

import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.IssueType;
import com.atlassian.jira.rest.client.domain.input.IssueInput;
import com.atlassian.jira.rest.client.domain.input.IssueInputBuilder;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.jira.JiraAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="JiraCreateIssue.wid", name="JiraCreateIssue", displayName="JiraCreateIssue", defaultHandler="mvel: new org.jbpm.process.workitem.jira.CreateIssueWorkitemHandler(\"userName\", \"password\", \"repoURI\")", documentation="jira-workitem/index.html", category="jira-workitem", icon="JiraCreateIssue.png", parameters={@WidParameter(name="ProjectKey", required=true), @WidParameter(name="IssueSummary"), @WidParameter(name="IssueDescription"), @WidParameter(name="IssueType"), @WidParameter(name="AssigneeName"), @WidParameter(name="ReporterName"), @WidParameter(name="ComponentName")}, results={@WidResult(name="CreatedIssueKey")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="jira-workitem", version="7.49.0.Final")}, serviceInfo=@WidService(category="Jira", description="Create or update Jiras", keywords="jira,issue,create", action=@WidAction(title="Create a new Jira issue"), authinfo=@WidAuth(required=true, params={"userName", "password", "repoURI"}, paramsdescription={"Jira user", "Jira password", "Repository URI"}, referencesite="https://www.atlassian.com/software/jira")))
public class CreateIssueWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private String repoURI;
    private JiraAuth auth;
    private static final Logger logger = LoggerFactory.getLogger(CreateIssueWorkitemHandler.class);
    private static final String RESULTS_VALUE = "CreatedIssueKey";

    public CreateIssueWorkitemHandler(String userName, String password, String repoURI) {
        this.userName = userName;
        this.password = password;
        this.repoURI = repoURI;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String projectKey = (String)workItem.getParameter("ProjectKey");
            String issueSummary = (String)workItem.getParameter("IssueSummary");
            String issueDescription = (String)workItem.getParameter("IssueDescription");
            String givenIssueType = (String)workItem.getParameter("IssueType");
            String assigneeName = (String)workItem.getParameter("AssigneeName");
            String reporterName = (String)workItem.getParameter("ReporterName");
            String componentName = (String)workItem.getParameter("ComponentName");
            if (this.auth == null) {
                this.auth = new JiraAuth(this.userName, this.password, this.repoURI);
            }
            HashMap<String, String> results = new HashMap<String, String>();
            IssueType issueTypeObj = null;
            if (StringUtils.isEmpty((CharSequence)givenIssueType)) {
                givenIssueType = "Bug";
            }
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            Iterable allIssueTypes = this.auth.getMetaDataRestClient().getIssueTypes((ProgressMonitor)progressMonitor);
            for (IssueType myIssueType : allIssueTypes) {
                if (!myIssueType.getName().equals(givenIssueType)) continue;
                issueTypeObj = myIssueType;
            }
            IssueInputBuilder issueBuilder = issueTypeObj != null ? new IssueInputBuilder(projectKey, issueTypeObj.getId(), issueSummary) : new IssueInputBuilder(projectKey, Long.valueOf(1L), issueSummary);
            if (StringUtils.isNotEmpty((CharSequence)issueDescription)) {
                issueBuilder.setDescription(issueDescription);
            }
            if (StringUtils.isNotEmpty((CharSequence)assigneeName)) {
                issueBuilder.setAssigneeName(assigneeName);
            }
            if (StringUtils.isNotEmpty((CharSequence)reporterName)) {
                issueBuilder.setReporterName(reporterName);
            }
            if (StringUtils.isNotEmpty((CharSequence)componentName)) {
                issueBuilder.setComponentsNames(Arrays.asList(componentName));
            }
            IssueInput issueInput = issueBuilder.build();
            BasicIssue toCreateIssue = this.auth.getIssueRestClient().createIssue(issueInput, (ProgressMonitor)progressMonitor);
            Issue createdIssue = this.auth.getIssueRestClient().getIssue(toCreateIssue.getKey(), (ProgressMonitor)progressMonitor);
            results.put(RESULTS_VALUE, createdIssue.getKey());
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Error executing workitem: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(JiraAuth auth) {
        this.auth = auth;
    }
}

