/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jira;

import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.SearchResult;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.jira.JiraAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="JiraJqlSearch.wid", name="JiraJqlSearch", displayName="JiraJqlSearch", defaultHandler="mvel: new org.jbpm.process.workitem.jira.JqlSearchWorkitemHandler()", parameters={@WidParameter(name="SearchQuery")}, results={@WidResult(name="SearchResults")}, mavenDepends={@WidMavenDepends(group="com.atlassian.jira", artifact="jira-rest-java-client", version="1.0")})
public class JqlSearchWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private String repoURI;
    private JiraAuth auth;
    private static final Logger logger = LoggerFactory.getLogger(JqlSearchWorkitemHandler.class);
    private static final String RESULTS_VALUE = "SearchResults";

    public JqlSearchWorkitemHandler(String userName, String password, String repoURI) {
        this.userName = userName;
        this.password = password;
        this.repoURI = repoURI;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            HashMap<String, String> resultIssues;
            HashMap results;
            String jqlQuery = (String)workItem.getParameter("SearchQuery");
            if (StringUtils.isNotEmpty((CharSequence)jqlQuery)) {
                if (this.auth == null) {
                    this.auth = new JiraAuth(this.userName, this.password, this.repoURI);
                }
                results = new HashMap();
                resultIssues = new HashMap<String, String>();
                NullProgressMonitor progressMonitor = new NullProgressMonitor();
                SearchResult searchResult = this.auth.getSearchRestClient().searchJql(jqlQuery, (ProgressMonitor)progressMonitor);
                Iterable foundIssues = searchResult.getIssues();
                for (BasicIssue issue : foundIssues) {
                    resultIssues.put(issue.getKey(), issue.getSelf().toURL().toString());
                }
            } else {
                logger.error("Missing search query.");
                throw new IllegalArgumentException("Missing search query.");
            }
            results.put(RESULTS_VALUE, resultIssues);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Error executing workitem: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(JiraAuth auth) {
        this.auth = auth;
    }
}

