/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jpa;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="JPADefinitions.wid", name="JPA", displayName="JPA", defaultHandler="mvel: new org.jbpm.process.workitem.jpa.JPAWorkItemHandler()", parameters={@WidParameter(name="Type"), @WidParameter(name="Id"), @WidParameter(name="Entity"), @WidParameter(name="Action"), @WidParameter(name="Query"), @WidParameter(name="QueryParameters"), @WidParameter(name="QueryResults")}, results={@WidResult(name="Result")}, mavenDepends={@WidMavenDepends(group="org.hibernate.javax.persistence", artifact="hibernate-jpa-2.1-api", version="1.0.0.Final"), @WidMavenDepends(group="org.hibernate", artifact="hibernate-entitymanager", version="5.1.4.Final")})
public class JPAWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler
implements Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(JPAWorkItemHandler.class);
    public static final String P_RESULT = "Result";
    public static final String P_TYPE = "Type";
    public static final String P_ID = "Id";
    public static final String P_ENTITY = "Entity";
    public static final String P_ACTION = "Action";
    public static final String P_QUERY = "Query";
    public static final String P_QUERY_PARAMS = "QueryParameters";
    public static final String P_QUERY_RESULTS = "QueryResults";
    public static final String CREATE_ACTION = "CREATE";
    public static final String UPDATE_ACTION = "UPDATE";
    public static final String GET_ACTION = "GET";
    public static final String DELETE_ACTION = "DELETE";
    public static final String QUERY_ACTION = "QUERY";
    private EntityManagerFactory emf;
    private ClassLoader classloader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPAWorkItemHandler(String persistenceUnit, ClassLoader cl) {
        this.setLogThrownException(true);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            this.emf = Persistence.createEntityManagerFactory((String)persistenceUnit);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        this.classloader = cl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void executeWorkItem(WorkItem wi, WorkItemManager wim) {
        actionParam = wi.getParameter("Action");
        entity = wi.getParameter("Entity");
        id = wi.getParameter("Id");
        type = wi.getParameter("Type");
        queryName = wi.getParameter("Query");
        queryParams = wi.getParameter("QueryParameters");
        params = new HashMap<String, Object>();
        queryResults /* !! */  = Collections.emptyList();
        if (actionParam == null) {
            throw new IllegalArgumentException("An action is required. Use 'delete', 'create', 'update', query or 'get'");
        }
        if (entity == null && "Action".equals("QUERY")) {
            throw new IllegalArgumentException("An entity is required. Use the 'entity' parameter");
        }
        action = String.valueOf(actionParam).trim().toUpperCase();
        JPAWorkItemHandler.logger.debug("Action {} on {}", (Object)action, entity);
        em = this.emf.createEntityManager();
        try {
            em.joinTransaction();
            var13_13 = action;
            var14_15 = -1;
            switch (var13_13.hashCode()) {
                case 2012838315: {
                    if (!var13_13.equals("DELETE")) break;
                    var14_15 = 0;
                    break;
                }
                case 70454: {
                    if (!var13_13.equals("GET")) break;
                    var14_15 = 1;
                    break;
                }
                case -1785516855: {
                    if (!var13_13.equals("UPDATE")) break;
                    var14_15 = 2;
                    break;
                }
                case 1996002556: {
                    if (!var13_13.equals("CREATE")) break;
                    var14_15 = 3;
                    break;
                }
                case 77406376: {
                    if (!var13_13.equals("QUERY")) break;
                    var14_15 = 4;
                }
            }
            switch (var14_15) {
                case 0: {
                    this.doDelete(em, entity, id);
                    ** break;
lbl44:
                    // 1 sources

                    break;
                }
                case 1: {
                    if (id == null || type == null) {
                        throw new IllegalArgumentException("Id or type can't be null when getting an entity");
                    }
                    entity = this.doGet(em, type.toString(), Long.parseLong(id.toString()));
                    ** break;
lbl50:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.doUpdate(em, entity);
                    ** break;
lbl55:
                    // 1 sources

                    break;
                }
                case 3: {
                    em.persist(entity);
                    ** break;
lbl59:
                    // 1 sources

                    break;
                }
                case 4: {
                    if (queryName == null) {
                        throw new IllegalArgumentException("You must provide a 'Query' parameter to run named queries.");
                    }
                    queryResults /* !! */  = this.doQuery(em, String.valueOf(queryName), queryParams);
                    ** break;
lbl65:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalArgumentException("Action " + action + " not recognized. Use 'delete', 'create', 'update', query, or 'get'");
                }
            }
        }
        catch (Exception e) {
            JPAWorkItemHandler.logger.debug("Error performing JPA action ", (Throwable)e);
            throw e;
        }
        finally {
            em.close();
        }
        params.put("Result", entity);
        params.put("QueryResults", queryResults /* !! */ );
        wim.completeWorkItem(wi.getId(), params);
    }

    private List<Object> doQuery(EntityManager em, String queryName, Object queryParams) {
        logger.debug("About to run query {}", (Object)queryName);
        Query namedQuery = em.createQuery(queryName);
        if (queryParams == null) {
            logger.debug("No parameters were provided");
        } else {
            Map params = (Map)queryParams;
            logger.debug("Parameters {}", (Object)params);
            params.forEach((arg_0, arg_1) -> ((Query)namedQuery).setParameter(arg_0, arg_1));
        }
        return namedQuery.getResultList();
    }

    private Object doUpdate(EntityManager em, Object entity) {
        return em.merge(entity);
    }

    private Object doGet(EntityManager em, String clazz, Object id) {
        Class<?> type = this.loadClass(clazz);
        return em.find(type, id);
    }

    private void doDelete(EntityManager em, Object entity, Object id) {
        if (!em.contains(entity)) {
            entity = this.doGet(em, entity.getClass().getName(), id);
        }
        if (entity == null) {
            throw new IllegalArgumentException("Can't load the entity to remove. Provide an attached entity or the id to load it.");
        }
        em.remove(entity);
    }

    public void close() {
        this.emf.close();
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
        wim.abortWorkItem(wi.getId());
    }

    private Class<?> loadClass(String clazz) {
        try {
            return Class.forName(clazz, false, this.classloader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't load type " + clazz);
        }
    }
}

