/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.longrest.demoservices;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hibernate.cfg.NotYetImplementedException;
import org.jbpm.process.longrest.demoservices.CookieListener;
import org.jbpm.process.longrest.demoservices.EventType;
import org.jbpm.process.longrest.demoservices.ServiceListener;
import org.jbpm.process.longrest.demoservices.dto.BuildRequest;
import org.jbpm.process.longrest.demoservices.dto.CompleteRequest;
import org.jbpm.process.longrest.demoservices.dto.PreBuildRequest;
import org.jbpm.process.longrest.demoservices.dto.Request;
import org.jbpm.process.longrest.demoservices.dto.Scm;
import org.jbpm.process.longrest.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/demo-service")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class Service {
    public static final String SERVICE_LISTENER_KEY = "serviceListener";
    public static final String COOKIE_LISTENER_KEY = "cookieListener";
    private static final Logger logger = LoggerFactory.getLogger(Service.class);
    public static final String PRE_BUILD_COOKIE_NAME = "myCookieName";
    public static final String PRE_BUILD_COOKIE_VALUE = "myCookieValue";
    ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    ObjectMapper objectMapper = new ObjectMapper();
    private static final Map<Integer, RunningJob> runningJobs = new ConcurrentHashMap<Integer, RunningJob>();
    private static final AtomicInteger sequence = new AtomicInteger();
    @Context
    ServletContext servletContext;

    @GET
    @Path(value="/")
    public Response test() {
        HashMap<String, Date> response = new HashMap<String, Date>();
        response.put("time", new Date());
        return Response.status((int)200).entity(response).build();
    }

    @POST
    @Path(value="/prebuild")
    public Response prebuild(PreBuildRequest request, @QueryParam(value="callbackDelay") @DefaultValue(value="3") int callbackDelay, @QueryParam(value="cancelDelay") @DefaultValue(value="1") String cancelDelay, @QueryParam(value="cancelHeartBeatAfter") @DefaultValue(value="5") String cancelHeartBeatAfter) throws JsonProcessingException {
        logger.info("> PreBuild requested.");
        logger.info("> Request object: " + this.objectMapper.writeValueAsString((Object)request));
        Request callback = request.getCallback();
        Scm scm = new Scm();
        scm.setUrl(request.getScm().getUrl());
        scm.setRevision("new-scm-tag");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("scm", scm);
        result.put("status", "SUCCESS");
        if (request.getHeartBeat() != null) {
            ScheduledFuture<?> heartBeat = this.startHeartBeat(request.getHeartBeat().getUrl());
            this.executorService.schedule(() -> heartBeat.cancel(true), Long.parseLong(cancelHeartBeatAfter), TimeUnit.SECONDS);
        }
        HashMap<String, String> response = new HashMap<String, String>();
        if (callback != null && !Strings.isEmpty((String)callback.getUrl())) {
            int jobId = this.scheduleCallback(callback.getUrl(), callback.getMethod(), null, callbackDelay, result);
            String cancelUrl = "http://localhost:8080/demo-service/cancel/" + jobId;
            cancelUrl = cancelUrl + "?delay=" + cancelDelay;
            response.put("cancelUrl", cancelUrl);
        }
        return Response.status((int)200).header("Set-Cookie", (Object)"myCookieName=myCookieValue").entity(response).build();
    }

    @POST
    @Path(value="/build")
    public Response build(BuildRequest request, @QueryParam(value="callbackDelay") @DefaultValue(value="5") int callbackDelay) throws JsonProcessingException {
        logger.info("> Build requested.");
        logger.info("> Request object: " + this.objectMapper.writeValueAsString((Object)request));
        this.serviceListener().fire(EventType.BUILD_REQUESTED, request);
        Request callback = request.getCallback();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("status", "SUCCESS");
        int jobId = this.scheduleCallback(callback.getUrl(), callback.getMethod(), null, callbackDelay, result);
        String cancelUrl = "http://localhost:8080/demo-service/cancel/" + jobId;
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("cancelUrl", cancelUrl);
        return Response.status((int)200).entity(response).build();
    }

    @POST
    @Path(value="/complete/{buildConfigId}")
    public Response complete(CompleteRequest completeRequest, @PathParam(value="buildConfigId") String buildConfigId) throws JsonProcessingException {
        logger.info("> Complete requested.");
        logger.info("> Request object: " + this.objectMapper.writeValueAsString((Object)completeRequest));
        HashMap<String, Map<String, Object>> response = new HashMap<String, Map<String, Object>>();
        response.put("labels", completeRequest.getLabels());
        return Response.status((int)200).entity(response).build();
    }

    @POST
    @Path(value="/cancel/{id}")
    public Response cancelAction(@PathParam(value="id") int jobId, @QueryParam(value="delay") @DefaultValue(value="1") int delay, @Context HttpHeaders httpHeaders) {
        logger.info("> Action Cancel requested for job:" + jobId);
        this.cookieListener().accept(httpHeaders.getCookies());
        RunningJob runningJob = runningJobs.get(jobId);
        runningJob.future.cancel(true);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("cancelled", "true");
        this.scheduleCallback(runningJob.callbackUrl, "POST", null, delay, result);
        HashMap response = new HashMap();
        return Response.status((int)200).entity(response).build();
    }

    private int scheduleCallback(String callbackUrl, String callbackMethod, List<NameValuePair> callbackParams, int delay, Object result) {
        ServiceListener serviceListener = this.serviceListener();
        ScheduledFuture<?> future = this.executorService.schedule(() -> this.executeRequest(callbackUrl, callbackMethod, callbackParams, result, serviceListener), (long)delay, TimeUnit.SECONDS);
        int id = sequence.getAndIncrement();
        runningJobs.put(id, new RunningJob(future, callbackUrl));
        return id;
    }

    private ScheduledFuture<?> startHeartBeat(String url) {
        ServiceListener serviceListener = this.serviceListener();
        ScheduledFuture<?> future = this.executorService.scheduleAtFixedRate(() -> this.executeRequest(url, "POST", Collections.emptyList(), null, serviceListener), 300L, 300L, TimeUnit.MILLISECONDS);
        return future;
    }

    private void executeRequest(String url, String method, List<NameValuePair> parameters, Object result, ServiceListener serviceListener) {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).setAuthenticationEnabled(true).build();
        try {
            URI requestUri = new URI(url);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(requestUri.getHost(), requestUri.getPort(), AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials("admin", "admin"));
            HttpClientBuilder clientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(config).setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            CloseableHttpClient httpClient = clientBuilder.build();
            HttpPut request = null;
            if (method == null || method.contentEquals("PUT")) {
                request = new HttpPut(requestUri);
            } else if (method.contentEquals("POST")) {
                request = new HttpPost(requestUri);
            } else {
                throw new NotYetImplementedException("This HTTP method is not implemented yet in this dummy service handler: " + method);
            }
            request.setHeader("Content-Type", "application/json");
            logger.info("> Invoking to: " + requestUri);
            String jsonContent = this.objectMapper.writeValueAsString(result);
            logger.info("> Data:" + jsonContent);
            StringEntity entity = new StringEntity(jsonContent, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            logger.info("> Invocation executed. Returned status: " + response.getStatusLine().getStatusCode());
            serviceListener.fire(EventType.CALLBACK_COMPLETED, url);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private ServiceListener serviceListener() {
        try {
            return (ServiceListener)this.servletContext.getAttribute(SERVICE_LISTENER_KEY);
        }
        catch (Throwable t) {
            logger.error("> Cannot get service listener.", t);
            return null;
        }
    }

    private CookieListener cookieListener() {
        try {
            return (CookieListener)this.servletContext.getAttribute(COOKIE_LISTENER_KEY);
        }
        catch (Throwable t) {
            logger.error("> Cannot get cookie listener.", t);
            return null;
        }
    }

    private class RunningJob {
        ScheduledFuture future;
        String callbackUrl;

        public RunningJob(ScheduledFuture future, String callbackUrl) {
            this.future = future;
            this.callbackUrl = callbackUrl;
        }
    }
}

