/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.longrest.mockserver;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/services/rest/server/containers/default-per-pinstance/processes/instances/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class WorkItems {
    private final Logger logger = LoggerFactory.getLogger(WorkItems.class);
    public static final String RUNTIME_MANAGER_KEY = "runtimeManager";
    @Context
    ServletContext servletContext;

    @POST
    @Path(value="{instanceId}/signal/{signalName}")
    public Response signalProcess(@PathParam(value="signalName") String signalName, @PathParam(value="instanceId") long instanceId, Map<String, Object> result) {
        this.logger.info("Mock server received signal {} and sending it to process id: {}, result: {}.", new Object[]{signalName, instanceId, result});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine(instanceId);
        KieSession kieSession = runtimeEngine.getKieSession();
        kieSession.signalEvent(signalName, result);
        this.disposeRuntimeEngine(runtimeEngine);
        return Response.status((int)200).entity(result).build();
    }

    private RuntimeEngine getRuntimeEngine(long processInstanceId) {
        ProcessInstanceIdContext processInstanceContext = ProcessInstanceIdContext.get((Long)processInstanceId);
        return this.getRuntimeManager().getRuntimeEngine((org.kie.api.runtime.manager.Context)processInstanceContext);
    }

    private void disposeRuntimeEngine(RuntimeEngine runtimeEngine) {
        this.getRuntimeManager().disposeRuntimeEngine(runtimeEngine);
    }

    private RuntimeManager getRuntimeManager() {
        return (RuntimeManager)this.servletContext.getAttribute(RUNTIME_MANAGER_KEY);
    }
}

